function index=fftround(rf,n)
% FFTROUND converts a reduced frequency value into
% the corresponding index location in a spectrum vector
% of length N with a round-off process compatible with
% FFT function.
% INDEX=FFTROUND(RF,N)
%	RF : reduced frequency, -0.5 < IFLAW < 0.5
%	N     : number of points of the spectrum vector
%	INDEX : resulting indexes
%

% FFTROUND((integer+0.5)/N,N)=n
% ROUND(integer+0.5)=n+1;
%
% E. Chassande, 1995.


if (min(rf)<-0.5)|(max(rf)>0.5),
 error('The values RF elements must be between -0.5 and 0.5');
end;

index=zeros(size(rf));

index(rf>=0)=round(n*rf(rf>=0))+1;
fprob=(rf>=0)&(round(2*n*rf)==2*n*rf);
index(fprob)=round(n*rf(fprob));

index(rf<0)=n+round(n*rf(rf<0))+1;
fprob=find((rf<0)&(round(2*n*rf)==2*n*rf));
index(fprob)=n+round(n*rf(fprob))+2;
