% Detection/Estimation of GW (chirp mass+coalescence time)
% I+T signal 2

% SIGNAL
% Input parameters:
m1   = 10;    % mass of object 1, in solar masses
m2   = 1;     % mass of object 2, in solar masses
r    = 200;   % distance binary-earth, in Mpc
tin  = 4.216; % time to coalescence, in seconds
fout = 500;   % high cut-off frequency, in Hertz (< fs/2))
fs   = 1000;  % sampling frequency, in Hertz
ts=1/fs;

% VIRGO exponents
alpha=1/4;
beta=5/8;

% total mass
M = m1 +m2;

% reduced mass
mu = 1/(1/m1 + 1/m2);

% chirp mass
calM = M^(2/5)*mu^(3/5);

% d
d = 160*3^(3/8)*calM^(-5/8);

% tout
% tout = 3*calM^(-5/3)*(fout/100)^(-8/3)
tout = (fout/(d*beta))^(1/(beta-1));

% amplitude
A = (400/3^(3/4))*1.92*10^(-23)*calM^(5/4)/r;
% A=abs(beta-1)^(1/2)*(d*beta)^((-alpha+1/2)/(beta-1));

% time vectors
t1 = (-tin:ts:0);
tcol=length(t1);
t2= (-tin:ts:-tout)';
nout=length(t2);

% waveform
x=zeros(tcol,1);
x(1:nout) = A*(abs(t2)).^(-alpha).*cos(2*pi*d*(abs(t2)).^(beta));

% instantaneous frequency
ifl  = zeros(tcol,1);
ifl(1:nout) = d*beta*(abs(t2)).^(beta-1);

% corresponding hyperbolic chirp exponents
r=(alpha-beta/2)/(beta-1);
k=beta/(beta-1);
c=-(beta-1)/beta*(d*beta)^(-1/(beta-1));
C=A*abs(beta-1)^(-1/2)*(d*beta)^((alpha-1/2)/(beta-1));

% SIGNAL
% observation
scol=4444; nz=50;
t=[-tin-ts*((scol-nz-tcol):-1:1) t1 ts*(1:nz)];
icoal=scol-nz;
sig=hilbert([zeros(scol-nz-tcol,1);x;zeros(nz,1)]);

% noise
[n dum dsp fd]=v_noise(scol,fs,ifl(1),fout);
clear dum

s=sig+n;

% reference
% on utilise la duree de la fenetre pour s'affranchir des effets
% de bord.
dt=2; hcol=dt*54+1;
tref= t1((hcol-1)/2:nout);
sref=  x((hcol-1)/2:nout);
fref=ifl((hcol-1)/2:nout);
Nr=length(sref);

% reference "whitening"
Nref=length(fd);
sref=[sref;zeros(Nref-Nr,1)];
sfref=fft(sref,Nref);
bdpas=find(dsp>0);
sfref(bdpas)=sfref(bdpas)./dsp(bdpas);
sref=ifft(sfref); 
clear Nref sfref;
sref=sref(1:Nr);

% spectrum
% Nfs=2^nextpow2(scol);
% sf=abs(ts*fft(s,Nfs)).^2;
% fsf=fs*(0:Nfs/2-1)/Nfs;
% sfap=C^2*fsf.^(-2*(r+1));

% plots
% clf;
% subplot(2,2,1); plot(t,real(s));
% axis([t(1) t(scol) -max(real(s)) max(real(s))]);
% title('observation signal');
% xlabel('time (s)');
% subplot(2,2,2);
% loglog(fsf(2:Nfs/2),sf(2:Nfs/2));
% hold on
% loglog(fsf(2:Nfs/2),sfap(2:Nfs/2),'--');
% hold off
% axis([2*fs/Nfs fs/2 min(sf(2:Nfs/2)) max(sf(2:Nfs/2))]);
% title('spectrum of the observation signal');
% xlabel('frequency (Hz)');
% subplot(2,2,3); plot(tref,real(sref));
% axis([t(1) t(scol) -max(real(sref)) max(real(sref))]);
% title('reference signal');
% xlabel('time (s)');
% subplot(2,2,4); plot(tref,fref);
% axis([t(1) t(scol) 0 fs/2]);
% title('instantaneous frequency');
% xlabel('time (s)'); ylabel('frequency (Hz)');
% fprintf('Ready ? ');
% %drawnow; pause;
% fprintf('Go !\n');

% DETECTION
% constantes bruit
s4=(0.7e-42)^2; % sigma^4
e=1; % exposant decroissance spectrale bruit

% tfr configuration
Nf=512;
ttfr=2:dt:scol;
tfcol=length(ttfr);
f=fs*(1:Nf/2)/Nf;
h=window(hcol,'gauss',1e-3); h=h/norm(h); % window

% Time-frequency distribution
% Computation with recorded observation signal (and corresponding TF dist)
% load These/chap4/acha6a; fprintf('\nloading acha6a.mat ...\n');
% Computation with current signal, i.e. current noise realization
[tfr rtfr]=tfrrsp(s,ttfr,Nf,h,1);

% Record :
% save These/chap4/acha6a

tfr2=ts*tfr(1:Nf/2,:); rtfr2=ts*rtfr(1:Nf/2,:);

% Matched filter
[mf mfpos]=mafi(s,sref,tcol-(hcol-1)/2+1,1);
mf=mf*ts^2;
mf=mf(ttfr); mfpos=mfpos/dt; % re-samplinf of mf on tfr grid.

% TF matched filter
fa=zeros(1,Nf/2);
fa(1)=0;
fa(2:Nf/2)=(fs*(1:Nf/2-1)'/Nf).^(2*(e-alpha/(beta-1)));
for n=1:tfcol,
  tfr2(:,n)=fa'.* tfr2(:,n);
 rtfr2(:,n)=fa'.*rtfr2(:,n);
end;

% smoothing
% fprintf('unsmoothed version...\n')
%rtfr2=conv2(rtfr2,kern,'same'); fprintf('\n smoothing...\n \n ');

% parameter space sampling
kv=logspace(log10(1),log10(100),101);
mv=linspace(0,2,51)';
kmat=ones(size(mv))*kv;
mmat=mv*ones(size(kv));
mr=(kmat.^3./(kmat+1)).^(1/5).*mmat;
mr0=mr(26,51);
mrmin=0.5*mr0;
mrmax=1.5*mr0;
ntest=21;
mrv=linspace(mrmin,mrmax,ntest);

indic=find((mr>mrmin)&(mr<mrmax));
mrobs=NaN*ones(size(mr));
mrobs(indic)=mr(indic);

% subplot(2,1,1);
% pcolor(kv,mv,mrobs);shading('flat');
% axis([kv(1) kv(101) mv(1) mv(51)]);
% colormap(flipud(gray));xlabel('m2/m1');ylabel('m1');
% hold on
% grid
% plot(1,10,'+');
% plot(1,1.4,'*');
% plot(10,1,'*');
% contour(kv,mv,mrobs,mrv);
% hold off
% xlabel('m2/m1');ylabel('m1');
% title('chirp mass');
% 
% subplot(2,2,3);
% dv=mrv.^(-5/8);
% plot(mrv,dv);
% axis([mrv(1) mrv(ntest) dv(ntest) dv(1)])
% hold on
% grid;
% plot([mr0 mr0],[dv(ntest) dv(1)],'--');
% hold off
% xlabel('chirp mass');ylabel('modulation rate d');
% 

fmin=ifl(1);
mtestsp =zeros(ntest,tfcol);
mtestrsp=zeros(ntest,tfcol);

% subplot(2,2,4);
%plot([]); hold on;
%imagesc(rtfr2(1:256,1:tfcol-25)); axis('xy');hold on;

for nc=1:ntest,
 calMref = mrv(nc); % M^(2/5)*mu^(3/5);
 dref = 160*3^(3/8)*calMref^(-5/8);
 tinref  = (fmin/(dref*beta))^(1/(beta-1));
 toutref = (fout/(dref*beta))^(1/(beta-1));
 Aref = (400/3^(3/4))*1.92*10^(-23)*calMref^(5/4)/r;
 Cref = Aref*abs(beta-1)^(-1/2)*(dref*beta)^((alpha-1/2)/(beta-1));
 cref =-(beta-1)/beta*(dref*beta)^(-1/(beta-1));

 % time vectors
 nin2 =min([tcol min(find(t1>-tinref))])
 nout2=max(find(t1<-toutref))-1
 t2   =t1(nin2:nout2)';
 iflref  = zeros(tcol,1);
 iflref(nin2:nout2)  = beta*dref*(abs(t2)).^( beta-1);
 % plot(t1,iflref);

 fref=iflref(nin2:nout2);
 Nr=length(fref);
 % plot((nin2:dt:nout2),512*fref(1:dt:/fs);hold on
 % plot((nin2:nout2)/dt,fftround(fref/fs,512),'r')
 % plot((tfcol-25-length(1:dt:Nr)+1):(tfcol-25),fftround(fref(1:dt:Nr)/fs,512)); drawnow;
 % plot((tfcol-75):(tfcol-25),fftround(fref(1:dt:Nr)/fs,512)); drawnow;
 % pause;
 % end;
 % axis([tfcol-75 tfcol-25 1 256]);

 % spectro
 [spmf  sppos]=tfmafi( tfr2,fref(1:dt:Nr)/fs,(tcol-nin2+1)/dt,1);
 mtestsp(nc,:) =(dt*ts)*Cref^2*spmf/s4/(cref*k*(k-1));
 
 % reass spectro
 [rspmf rsppos]=tfmafi(rtfr2,fref(1:dt:Nr)/fs,(tcol-nin2+1)/dt,1);
 mtestrsp(nc,:)=(dt*ts)*Cref^2*rspmf/s4/(cref*k*(k-1));
end;

% hold off;
% xlabel('time (s)');
% ylabel('frequency (Hz)');

ntest=length(mrv);
mtestrspnorm=zeros(size(mtestrsp));
mtestspnorm=zeros(size(mtestrsp));
for n=1:ntest,
 mtestspnorm(n,:)=mtestsp(n,:)/mrv(n)^(5/3);
 mtestrspnorm(n,:)=mtestrsp(n,:)/mrv(n)^(5/3);
end;

mfmaxsp =max(max(mtestspnorm));
mfmaxrsp=max(max(mtestrspnorm));

figure(1)
clf
tmesh=1797; %tmesh=1448;
mesh(t(ttfr(tmesh:2:tfcol)),mrv,mtestrspnorm(:,tmesh:2:tfcol));
axe=[t(ttfr(tmesh)) t(scol) mrv(1) mrv(ntest) 0 mfmaxrsp];
axis(axe);
xlabel('temps (s)');
ylabel('chirp mass');
colormap(ones(size(jet)))
set(gca,'box','on');
hold on
plot3([0 0],[min(mrv) max(mrv)],[mfmaxrsp mfmaxrsp],'--');
plot3([t(ttfr(tmesh)) t(scol)],[calM calM],[mfmaxrsp mfmaxrsp],'--');
hold off
view([-17 57]);
% print -dps These/chap4/acha6a.ps

figure(2)
clf
mesh(t(ttfr(tmesh:2:tfcol)),mrv,mtestspnorm(:,tmesh:2:tfcol));
axe=[t(ttfr(tmesh)) t(scol) mrv(1) mrv(ntest) 0 mfmaxsp];
axis(axe);
xlabel('temps (s)');
ylabel('chirp mass');
colormap(ones(size(jet)))
set(gca,'box','on');
hold on
plot3([0 0],[min(mrv) max(mrv)],[mfmaxsp mfmaxsp],'--');
plot3([t(ttfr(tmesh)) t(scol)],[calM calM],[mfmaxsp mfmaxsp],'--');
hold off
view([-17 57]);
% print -dps These/chap4/acha6b.ps