% figure1 : On the time-freq. detection of chirps.
clear
m1=10; m2=10; r=1000; 
fmin=50; fmax=500;
tin=.515; fs=1000;
[tout,t,x,sref,f,nout,d] = plchirp(m1,m2,r,tin,fmax,fs);
x=hilbert([x;zeros(100,1)]/norm(x));
t=[t (1:100)/fs];

f=[f(1:nout);NaN*ones(length(x)-nout,1)];
h=roundwin(256);

xout=nout+80; Nf=128;
[tfru tu fu]=tfrspbk(x,1:4:xout,-5/3,32,0,0.05,0.50,Nf,1);
tu=t(1:4:xout);
[sp rsp]=tfrrsp(x,1:4:xout,2*Nf,h,1);
wv=tfrwv(x,1:4:xout,Nf,1);
fsp=(1:Nf)/(2*Nf);
[sc tsc fsc]=tfrscalo(x,1:4:xout,sqrt(xout),0.05,0.5,Nf,1);
tsc=t(1:4:xout);
ttf=t(1:4:xout);

fplotmax=500;
findicmax=min(find((fsp*fs)>=fplotmax));
subplot(2,3,1);
plot(t(1:xout),f(1:xout));
axis([t(1) t(xout) fmin fplotmax]);
axis('square')
xlabel('temps (s)');
ylabel('frequence (Hz)');
title('(a)');

subplot(2,3,2);
pcolor(tu,fu*fs,abs(tfru));
shading('flat');
colormap(flipud(gray));
axis([t(1) t(xout) fmin fplotmax]);
axis('square')
xlabel('temps (s)');
ylabel('frequence (Hz)');
title('(b)');

subplot(2,3,3);
imagesc(ttf,fsp(1:findicmax)*fs,rsp(1:findicmax,:));
axis('xy');
colormap(flipud(gray));
axis([t(1) t(xout) fmin fplotmax]);
axis('square')
xlabel('temps (s)');
ylabel('frequence (Hz)');
title('(c)');

subplot(2,3,4);
imagesc(ttf,fsp(1:findicmax)*fs,(wv(1:findicmax,:)+abs(wv(1:findicmax,:)))/2);
axis('xy');
colormap(flipud(gray));
axis([t(1) t(xout) fmin fplotmax]);
axis('square')
xlabel('temps (s)');
ylabel('frequence (Hz)');
title('(d)');

subplot(2,3,5);
imagesc(ttf,fsp(1:findicmax)*fs,sp(1:findicmax,:));
axis('xy');
colormap(flipud(gray));
axis([t(1) t(xout) fmin fplotmax]);
axis('square')
xlabel('temps (s)');
ylabel('frequence (Hz)');
title('(e)');

subplot(2,3,6);
pcolor(tsc,fsc*fs,sc);
shading('flat');
colormap(flipud(gray));
axis([t(1) t(xout) fmin fplotmax]);
axis('square')
xlabel('temps (s)');
ylabel('frequence (Hz)');
title('(f)');

% print -deps These/chap4/fig4.ps