% GRWAVE.M
%
% P. Flandrin, 05/12/97. Last modification 05/19/97.
%
% This program plots the waveform of a gravitational
% wave expected to be radiated by a coalescing binary
% in a Newtonian approximation, its instantaneous 
% frequency and its normalized energy spectrum
% (together with its stationary phase approximation).
%
% It makes use of PLCHIRP.M

% input parameters
m1 = 10;     % mass of object 1, in solar masses
m2 = 10;     % mass of object 2, in solar masses
r = 200;     % distance binary-earth, in Mpc
tin = 4;     % time to coalescence, in seconds
fout = 500;  % high cut-off frequency, in Hz
fs = 2000;   % sampling frequency, in Hz
dr = 40;     % dynamic range of the energy spectrum, in dB

% waveform and instantaneous frequency
[tout,t,x,dum,f,nout,d,slope] = plchirp(m1,m2,r,tin,fout,fs);
clear dum;

% evaluation of the normalized energy spectrum
xnorm = x/max(max(x));
T = max(size(xnorm));
N = ceil(log2(T));
fxnorm = fft(xnorm,2^N);
freq = linspace(0,fs/2,2^(N-1)+1);
spec = abs(fxnorm(1:2^(N-1)+1)).^2;
spec = spec/max(max(spec));
l = max(size(freq));

% plot of the waveform
figure(1);
subplot(411)
plot(t,x)
hold on
plot([-tin 0],[0 0])
hold off 
h=get(gca,'position'); set(gca,'position',h.*[1 1 1 0.7]);
title(['(a) - onde gravitationnelle (m1 = ',num2str(m1),', m2 = ',num2str(m2),', r = ',num2str(r),' Mpc)'])
xlabel('temps (seconde)')
ylabel('amplitude')
a=1.2*max(abs(x));
axis([-tin 0 -a a]);

% plot of the instantaneous frequency
subplot(412)
plot(t,f)
h=get(gca,'position'); set(gca,'position',h.*[1 1 1 0.7]);
title('(b) - frequence instantannee')
xlabel('temps (seconde)')
ylabel('frequence (Hz)')
axis([-tin 0 0 fout]);

% critere valid. approx ph. stat.
d0=d*5/8;
critere=115/576*freq.^(5/3)/(d0^(8/3)*pi);
indiccrit=max(find(critere<0.1));

fcrit=freq(indiccrit);

% plot of the spectrum
subplot(413)
semilogx(freq(2:l),10*log10(spec(2:l)));
axis([1 fs/2 -dr 0]);
hold on

% plot of the stationary phase approximation of the spectrum
fc = min(find(freq > sqrt(f(1)*fout)));
specd = (log10(spec(fc)))*10-(log10(f(1))-log10(fout))*10*slope;
specf = (log10(spec(fc)))*10+(log10(f(1))-log10(fout))*10*slope;
semilogx([f(1) f(1)],[-dr specd],'--');
semilogx([fout fout],[-dr specf],'--');
semilogx([f(1) fout],[specd specf],'--');
axe=axis;
%semilogx([fcrit fcrit],[axe(3) axe(4)],'--');
hold off
h=get(gca,'position'); set(gca,'position',h.*[1 1 1 0.7]);
title('(c) - spectre d''energie normalisee et approx. de phase stat.')
xlabel('frequence')
ylabel('dB')

subplot(414)
semilogx(freq,critere);
grid
hold on
%semilogx([fcrit fcrit],[critere(1) critere(l)],'--');
axis([1 fs/2 0 critere(l)]);
hold off
h=get(gca,'position'); set(gca,'position',h.*[1 1 1 0.7]);
title('(d) - critere de validite de l''argument de phase stationnaire')
xlabel('frequence')

approxcrit=specd+(specf-specd)*(log10(fcrit)-log10(f(1)))/(log10(fout)-log10(f(1)))
valuecrit =10*log10(spec(indiccrit))
valuecrit-approxcrit

% print -deps These/chap4/fig2.ps