load These/chap3/propa1
% le fichier propa1.mat peut etre creer
% avec la fonction propa1.m

f=(0:N/2-1)/N;
tps=1:176;
npart=length(center2);

% Graphique de connexite (fait "a la main")
chirp1=[1,9,15,21,33];
chirp2=[18,6,17,34,39];
chirp3=[7,4,5,11,23,35,40];
chirp4=[2,10,14,24,27,32];
chirp5=[8,19,13,20,26,29,38,41];
chirp6=[12,22,25,31,37];
chirp7=[28,30,36];

figure(1)
pc4=zeros(size(part2));
for ncol=chirp4,
  pc4=pc4+(part2==ncol);
end;

load These/chap3/propa1sig

s=decimate(s,2);
s=s(100:450);
tcol=length(s);
tps=1:tcol;

masc=zeros(N,tcol);
for ncol=1:(tcol-1)/2,
  masc(:,2*ncol-1:2*ncol)=[pc4(:,ncol) pc4(:,ncol)];
end;

s4=tffilter(masc,s,1:351,1);

h=window(127,'gauss',1e-3);
tfr=tfrsp(s,tps,256,h,1);
tfr4=tfrsp(s4,tps,256,h,1);

t=tps/fe*1000;
f=(0:N/2-1)/N*fe;

subplot(1,3,1);
imagesc(t,f,tfr(1:N/2,:));
hold on;
contour(t,f,masc(1:N/2,:),[1],'k--');
axis('xy');
colormap(flipud(gray));
xlabel('temps (ms)');
ylabel('frequence (kHz)');
title('(a)');
hold off;
axis('square');

subplot(1,3,2);
plot(t,real(s4));
axis([0 t(end) -max(real(s4)) max(real(s4))]);
title('(b)');
xlabel('temps (ms)');
axis('square');

subplot(1,3,3);
imagesc(t,f,tfr4(1:N/2,:));
axis('xy');
title('(c)');
xlabel('temps (ms)');
ylabel('frequence (kHz)');
axis('square');

set(gcf,'PaperPosition',[0.4 3.63 7.7 3.74]);
print -deps These/chap3/propa1.ps


