% Partition - Fusion
% Tableau 3.2

% Fichier mat
load merging2test
% le fichier merging2.mat peut etre creer
% avec la fonction merging2.m

% Carte propre
ncenter=max(max(part));
etiq=zeros(1,ncenter);
npart=0;
for ncol=1:ncenter,
  npoint=sum(sum(part==ncol));
  if (npoint>100),
    npart=npart+1;
    indic=find(part==ncol);
    part2(indic)=npart*ones(size(indic));
    etiq(npart)=ncol;
    clear indic
  end;
end;

Nc=npart;
center2=zeros(1,Nc); % centres dans la carte propre
center2=center(etiq(1:Nc));

part=part2;
center=center2;

dspe=NaN*zeros(1,Nc);
dinf=NaN*zeros(1,Nc);
denc=NaN*zeros(1,Nc);
dishsp=NaN*zeros(1,Nc);
y=zeros(length(tps),Nc);

for ncol=1:Nc,
  fprintf('*** Composante no %2.0f ******\n\n',ncol);
  % Pour chaque composante :
  % Reconstruction de chaque composante
  masc=(part==ncol);
  y(:,ncol)=tffilter(masc,x(tps),1:length(tps),1);
  % [tfrrec tmes fmes]=tfrsp(y(:,ncol),1:length(tps),Nre,h,1);
  % df=fmes(2)-fmes(1); clear tmes fmes; dt=1; d=dt*df; 
  
  % Information
  % Masque surechantillonnne
  masc4=zeros(N,length(tps));
  fact=N/Nre;
  for jcol=1:Nre,
    nres=fact*(jcol-1)+1;
    masc4(nres:nres+3,:)=ones(fact,1)*masc(jcol,:);
  end;
  tfrrec=tfrsp(y(:,ncol),1:length(tps),N,h,1);
  
  % Calcul de la diff. des entropies de SH sur sp et sp reconst
  dinf(ncol)=renyi2(tfrrec,t2,f2,1)-renyi2(tfr2.*masc4,t2,f2,1);
  
  % Calcul de ISH+SP
  dishsp(ncol)=renyi2(tfr2.*masc4,t2,f2,1);
  
  % Calcul Surface equivalente
  [tv fv]=meshgrid(t2,f2(1:N/2));
  df=f2(2)-f2(1); dt=1; d=dt*df; 
  tfr3=tfr2.*masc4;tfr3=tfr3/(d*sum(sum(tfr3(1:N/2,:))));
  mt=d*sum(sum(tv.*tfr3(1:N/2,:))); mf=d*sum(sum(fv.*tfr3(1:N/2,:)));
  denc(ncol)=d*sum(sum((((tv-mt)/deltat).^2+((fv-mf)/deltaf).^2).*tfr3(1:N/2,:)));
  
  % Calcul de l'energie a l'exterieur du bassin d'attraction
  dspe(ncol)=d*sum(sum(tfrrec(1:N/2,:).*(1-masc4(1:N/2,:))))/norm(y(:,ncol))^2;
  % fprintf('\nverif. : %3.2f \n',d*sum(sum(tfrrec))/norm(y(:,ncol))^2);
end;

% Plot
figure(1);
f=(0:Nre/2-1)/Nre;

subplot(1,2,1);
imagesc(1:length(tps),f,tfr(1:Nre/2,:));
axis('xy');
colormap(flipud(gray));
xlabel('temps');
ylabel('frequence');
title('(a)');

subplot(1,2,2);
image(1:length(tps),f,5*part2(1:Nre/2,:));
hold on;

% Numero de composante et limites
for ncol=1:Nc,
  plot(real(center(ncol)),imag(center(ncol))/Nre,'+');
  text(real(center(ncol))+3,imag(center(ncol))/Nre-0.03,num2str(ncol));
  contour(1:length(tps),f,part2(1:Nre/2,:)==ncol,1,'k--');
end;

% Graphe de connexite
graphconnex=[1,2;2,3;3,4;3,5;3,6;4,5;5,6];

% Graphe
[ncx mcx]=size(graphconnex);
for ncol=1:ncx,
  plot([real(center(graphconnex(ncol,1))) real(center(graphconnex(ncol,2)))],...
  [imag(center(graphconnex(ncol,1))) imag(center(graphconnex(ncol,2)))]/Nre,'k');
end;

% Points frontieres sur le graphe
tabmax=zeros(1,npart);
for ncol=1:npart,
  tabmax(ncol)=max(max(tfr.*(part2==ncol)));
end;

hold on;
for ncol=1:ncx,
  point1=round(center(graphconnex(ncol,1))); 
  point2=round(center(graphconnex(ncol,2)));
  % plot(real(point1),imag(point1)/Nre,'+b');
  % plot(real(point2),imag(point2)/Nre,'+b');
  
  decid1=graphconnex(ncol,1);
  decid2=graphconnex(ncol,2);
  
  if decid1~=part(imag(point1),real(point1)),
    fprintf('Attention ca ne marche pas !\n');
  end;
  if decid2~=part(imag(point2),real(point2)),
    fprintf('Attention ca ne marche pas !\n');
  end;

  while abs(point2-point1)>sqrt(2),
    pointmil=round((point1+point2)/2);
    decid=part(imag(pointmil),real(pointmil));
    if decid==decid1,
      point1=pointmil;
    else
      point2=pointmil;
    end;
  end;
  ptmil(ncol)=floor((point1+point2)/2);
  plot(real(pointmil),imag(pointmil)/Nre,'or');
  M1=tabmax(graphconnex(ncol,1));
  M2=tabmax(graphconnex(ncol,2));
  crfront(ncol)=tfr(imag(pointmil),real(pointmil))/sqrt(M1*M2);
end;

hold off
axis('xy');
colormap(flipud(gray));
xlabel('temps');
ylabel('frequence');
title('(b)');

% print -deps These/chap3/merging2.ps

disp('Tableau 3.2 :')
disp('Surface equivalente : ');
fprintf('%3.2f ',denc);
fprintf('\n borne : %3.2f\n',(1/(2*pi)));
disp('Information de Sh. : ');
fprintf('%3.2f ',2.^(dishsp-irefsp));
fprintf('\n borne : %3.2f\n',1);
disp('Energie ext. au domaine');
fprintf('%3.2f ',dspe);
fprintf('\n borne : %3.2f\n',0.5);
disp('Difference d''info. de Sh : ');
fprintf('%3.2f ',2.^(dinf-irefsp));
fprintf('\n borne : %3.2f\n',1);
fprintf('\n\n');
disp('Tableau 3.3 :')
disp('Energie a la coupure : ');
fprintf('%3.2f ',crfront);
