% Partition - Fusion
% Exemple de partition-fusion
% par les approches realloc diff., et informationnelle
% Genere le fichier cominfo.mat utilise ensuite par comfig.m
 

Nre=64;
N=256;
fmin=0; fmax=0.5;
long1=201;
T1=sqrt(-pi/log(1e-3))*(long1+1)/2;
logon1=amgauss(long1,(long1+1)/2,T1);

% Parametres reglables (ecart temp., phase) 
T=16; SNR=0;
PHI=linspace(-pi,pi,20);
PHI=PHI(7);

% fenetre
t0=ceil(sqrt(Nre)*sqrt(-log(1e-3)/pi));
h=amgauss(2*t0+1,t0+1,sqrt(Nre));
h=h/norm(h);
[dum deltat]=loctime(h); [dum deltaf]=locfreq(h);
clear dum

% Information de reference
logonref=h;                         % sqrt(Nre) pour obtenir le quantum d'info
longref=2*t0+1;                     % pour le spectro
xref=zeros(2*longref+1,1);
tps=longref+1+(-31:32);
mid1=longref+1;
xref(mid1+(-(longref-1)/2:(longref-1)/2))=xref(mid1+(-(longref-1)/2:(longref-1)/2))+logonref;
xref=xref.*exp(2*pi*i*0.25*(1:2*longref+1)');

[tfrref tref fref]=tfrsp(xref,tps,N,h);
irefsp=renyi2(tfrref,tref,fref,1), % en fait, c'est 1/log(2) 

tps=2*long1+1+(-31:32);

% Signal
Trow=T(tcol);
s=zeros(4*long1+1,1);
mid1=2*long1+1; % +ceil(Trow/2); mid2=2*long1+1-floor(Trow/2);
s(mid1+(-(long1-1)/2:(long1-1)/2))=s(mid1+(-(long1-1)/2:(long1-1)/2))...
    +logon1.*fmlin(long1,fmin,fmax,(long1+1)/2-ceil(Trow/2))*exp(i*PHI);
original=s(tps);
%x(mid2+(-(long2-1)/2:(long2-1)/2))=x(mid2+(-(long2-1)/2:(long2-1)/2))...
%+logon2.*fmlin(long2,fmin,fmax,(long2+1)/2+floor(Trow/2));
b=noisecg(4*long1+1);
x=sigmerge(s,b,SNR);

[tfr2 t2 f2]=tfrsp(x,tps,N,h);

% Reallocation - Partition
[part center tfr tf2]=tfrpart(x,tps,Nre,h,0.4,1);

% save merging2test Nre N fmin fmax long1 T SNR PHI h irefsp tps s b x part center tfr tfr2 tfr2 t2 f2