% Chapitre 3 : Forme analytique du champ de reallocation de 3 logons.
% tesselation temps-frequence


clear
% signal
te=1/5; fe=1/te;
t0=3;
t=(-3*t0/te:3*t0/te)';
tps=1:length(t);
s1=exp(-(t*te+t0).^2/2).*exp(2*pi*i*0.25*t);
s2=exp(-(t*te-t0).^2/2).*exp(2*pi*i*0.25*t);
s3=exp(-(t*te).^2/2).*exp(i*t0*t*te).*exp(2*pi*i*0.25*t);
s=s1+s2+s3;

% fenetre
th=-63:63;h=exp(-(th*te).^2/2);

% parametre
Nre=64;
tt=te*t; ff=2*pi*fe*(-Nre/2:Nre/2-1)/Nre;

% tfr=tfrsp(s,tps,Nre,h',1);
% keyboard;

% partition
[part center tfr tf2]=tfrpart(s,tps,Nre,h',0.4,1);
r=opreassp(s,tps,Nre,h',1);

% tf map cleaning
part2=zeros(size(part));
ncount=1;
for ncol=1:max(max(part));
  npoint=sum(sum(part==ncol));
  if npoint>100,
    part2=part2+ncount*(part==ncol);
    ncount=ncount+1;
  end;
end;
part=part2;

% tesselation
x = t0*[1 -1 0 -10 -10 10 10]; 
y = t0*[0 0 1 -10 10 -10 10]; 
[vx, vy] = voronoi(x,y);

figure(1);
clf;
% spectrogramme
subplot(1,3,1);
tfr=[tfr(3*Nre/4+1:Nre,:);tfr(1:3*Nre/4,:)];
imagesc(tt,ff,tfr);
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(a)');
axis('square');
colormap(flipud(gray));

% chp de vect

% subplot(2,2,2);
% quiver(tm,wm,-imag(r),-real(r))
% hold on;
% h1=plot([tv(nmid) tv(nmid)],[wv(1) wv(nmid)],'--');
% h2=plot(tv(nmid:end),wv(nmid:end),'--');
% h3=plot(-tv(nmid:end),wv(nmid:end),'--');
% set(h1,'LineWidth',2);
% set(h2,'LineWidth',2);
% set(h3,'LineWidth',2);

% hold off
% axis([tt(1) tt(end) ff(1) ff(end)]);
% axis('square');
% xlabel('temps');
% ylabel('frequence');
% title('(b)');
% grid;

% partition
subplot(1,3,2);
Threshold=1e-3*norm(x);
indict=1:2:length(t);indicf=1:2:Nre;
[tm wm]=meshgrid(tt(indict),ff(indicf));
r=[r(3*Nre/4+1:Nre,:);r(1:3*Nre/4,:)];
r=r.*(tfr>Threshold);
r=r(indicf,indict);
quiver(tm,wm,te*real(r),2*pi*fe*imag(r)/Nre,2);
axis([tt(1) tt(end) ff(1) ff(end)]);
hold on;
h=plot(vx,vy,'b-');
set(h,'LineWidth',2);
xlabel('temps');
ylabel('frequence');
axis('square');
title('(b)');
hold off


subplot(1,3,3);
part=[part(3*Nre/4+1:Nre,:);part(1:3*Nre/4,:)];
image(tt,ff,12*part);
hold on;
plot(x,y,'r+');
% hold off;
axis('xy');
% xlabel('temps');
% ylabel('frequence');
% axis('square');
% title('(c)');
% colormap(flipud(gray));
% print -deps /home/damiel/echassan/These/chap3/logon3c.ps

% tesselation
% plot(x,y,'r+');
% hold on;
h=plot(vx,vy,'b-');
set(h,'LineWidth',2);
axis([tt(1) tt(end) ff(1) ff(end)]);
xlabel('temps');
ylabel('frequence');
axis('square');
title('(c)');
hold off
grid;

% print -deps These/chap3/logon3.ps












