clear

Nt=64;
Nf=256;
RSB=2;
t=linspace(-10,10,Nt);
sig=hermite(8,t).*exp(2*pi*i*0.25*(1:Nt)');
sigplot=hermite(8,t);

t=1:Nt;
f=(1:Nf/2)/Nf;

h=amgauss(65,33,sqrt(256));
% Reallocation
% [sp rsp tf E fct]=tfrrsp2(s,1:Nt,Nf,window(T,'gauss',1e-3),1);
disp('Reallocation...');
[sp rsp tf]=tfrrsp(sig,1:Nt,Nf,h);
fct=tfrstft(sig,1:Nt,Nf,h);

% Ridge & Skeleton
% Ridge : ens. des points stationnaires de la reallcation :
disp('Ridge & Skeleton...');
r=zeros(Nt,1);
start=40;
for n=1:Nt,
 rn=real(tf(start,n));
 compteur=0;
 % n
 % disp('++++++++++');
 while (abs(r(n)-rn)>0.5)&(compteur<100)&(rn>0)&(rn<Nf+1),
   compteur=compteur+1;
   r(n)=rn;
   rn=real(tf(r(n),n));
 end;
 if (rn<1)|(rn>Nf),
   r(n)=nan;
   start=Nf/2;
 else
   r(n)=rn;
   start=r(n);
 end;
end;

% Skeleton
ske=zeros(size(sp));
for n=1:Nt
 if finite(r(n)),
  ske(r(n),n)=fct(r(n),n);
 end
end;

% Ridge & Skeleton 2
% Ridge : ens. des points stationnaires de la reallcation :
disp('Ridge & Skeleton...');
r=zeros(Nt,1);
start=80;
for n=1:Nt,
 rn=real(tf(start,n));
 compteur=0;
 % n
 % disp('++++++++++');
 while (abs(r(n)-rn)>0.5)&(compteur<100)&(rn>0)&(rn<Nf+1),
   compteur=compteur+1;
   r(n)=rn;
   rn=real(tf(r(n),n));
 end;
 if (rn<1)|(rn>Nf),
   r(n)=nan;
   start=Nf/2;
 else
   r(n)=rn;
   start=r(n);
 end;
end;

% Skeleton
ske2=zeros(size(sp));
for n=1:Nt
 if finite(r(n)),
  ske2(r(n),n)=fct(r(n),n);
 end
end;

% Densite de frequence instantannee
disp('Densite de frequence instantanee...');
idf=zeros(size(sp));
for icol=1:Nt,
  disprog(icol,Nt,10);
  for jcol=1:Nf,
    if finite(real(tf(jcol,icol))),
      jcolhat= round(real(tf(jcol,icol)));
      % jcolhat=rem(rem(jcolhat-1,Nf)+Nf,Nf)+1;
      idf(jcolhat,icol)=idf(jcolhat,icol) + 1;
    end;
  end;
end;
idf=idf/sum(sum(idf));

% Squeeze plane
% En version "de base", sans tous les algo d'amelioration
% specifique au traitement de la parole.
% : reallocation du module et de la fct...
disp('Squeezing...');
squeeze1=zeros(size(sp));
squeeze2=zeros(size(sp));
for icol=1:Nt,
  disprog(icol,Nt,10);
  for jcol=1:Nf,
    if finite(real(tf(jcol,icol))),
      jcolhat=round(real(tf(jcol,icol)));
      % jcolhat=rem(rem(jcolhat-1,Nf)+Nf,Nf)+1;
      squeeze1(jcolhat,icol)=squeeze1(jcolhat,icol) + abs(fct(jcol,icol));
      squeeze2(jcolhat,icol)=squeeze2(jcolhat,icol) + fct(jcol,icol);
    end;
  end;
end;
squeeze=(abs(squeeze2)+squeeze1)/2;
clear squeeze1 squeeze2


figure(1)
subplot(2,3,1);
plot(sigplot);
axis([1 Nt min(real(sigplot)) max(real(sigplot))]);
xlabel('temps');
title('(a)');

subplot(2,3,2);
imagesc(t,f,abs(ske(1:Nf/2,:)));
colormap(flipud(gray))
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(b)');

subplot(2,3,3);
imagesc(t,f,abs(ske2(1:Nf/2,:)));
colormap(flipud(gray))
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(c)');

subplot(2,3,4);
imagesc(t,f,idf(1:Nf/2,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(d)');

subplot(2,3,5);
imagesc(t,f,squeeze(1:Nf/2,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(e)');

subplot(2,3,6);
imagesc(t,f,rsp(1:Nf/2,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(f)');

% print -deps These/chap1/phfct3.ps
