clear

Nt=192;
Nf=256;
RSB=10;

s1=exp(2*pi*i*0.1*(1:64)');
s1=s1/norm(s1);             % frequence
s1(32)=s1(32)+1;            % impulsion
s2=amgauss(64,32,32).*fmlin(64,0.1,0.3); % chirp
s2=s2/norm(s2);
s3=amgauss(64,32,sqrt(256)).*exp(i*2*pi*0.25*(1:64)'); % logon
s3=s3/norm(s3);
s=[s1;s2;s3];               % signal final
b=noisecg(Nt);            % bruit

sig=s; % sigmerge(s,b,RSB);

t=1:Nt;
f=(1:Nf/2)/Nf;

h=amgauss(65,33,sqrt(256));
% Reallocation
% [sp rsp tf E fct]=tfrrsp2(s,1:Nt,Nf,window(T,'gauss',1e-3),1);
disp('Reallocation...');
[sp rsp tf]=tfrrsp(sig,1:Nt,Nf,h);
fct=tfrstft(sig,1:Nt,Nf,h);

% Ridge & Skeleton
% Ridge : ens. des points stationnaires de la reallcation :
disp('Ridge & Skeleton...');
r=zeros(Nt,1);
start=256*0.1+10;
for n=1:Nt,
 rn=real(tf(start,n));
 compteur=0;
 % n
 % disp('++++++++++');
 while (abs(r(n)-rn)>0.5)&(compteur<100)&(rn>0)&(rn<Nf+1),
   compteur=compteur+1;
   r(n)=rn;
   rn=real(tf(r(n),n));
 end;
 if (rn<1)|(rn>Nf),
   r(n)=nan;
   start=Nf/2;
 else
   r(n)=rn;
   start=r(n);
 end;
end;

% Skeleton
ske=zeros(size(sp));
for n=1:Nt
 if finite(r(n)),
  ske(r(n),n)=fct(r(n),n);
 end
end;

% Analyse spectrale differentielle
disp('Analyse spectrale differentielle...');
% Teq=round(T-1)/2/sqrt(4*pi)); % en general egal a la demi periode du sig
% On se debrouille pour que les durees des fenetres gauss et rect soient
% egales, cf. cahier 7
Teq=round(sqrt(6)*sqrt(256)/2); % demi longueur
% [asd rasd asdtf E asdfct]=tfrrsp2(s,1:Nt,Nf,ones(2*Teq+1,1)/(2*Teq+1),1);
hr=ones(2*Teq+1,1);hr=hr/norm(hr);
% [asd]=tfrsp2(sig,1:Nt,Nf,hr);
asdfct=tfrstft(sig,1:Nt,Nf,hr);
f0=25;
% disp('Largeur de bande d''analyse : ');
% f(2)-f(1)
% Proportion d'energie dans la bande d'analyse
asdsp=abs(asdfct).^2;
R=asdsp(f0,:)./sum(asdsp);
theta=unwrap(angle(asdfct(f0,:)));

% Densite de frequence instantannee
disp('Densite de frequence instantanee...');
idf=zeros(size(sp));
for icol=1:Nt,
  disprog(icol,Nt,10);
  for jcol=1:Nf,
    if finite(real(tf(jcol,icol))),
      jcolhat= round(real(tf(jcol,icol)));
      % jcolhat=rem(rem(jcolhat-1,Nf)+Nf,Nf)+1;
      idf(jcolhat,icol)=idf(jcolhat,icol) + 1;
    end;
  end;
end;
idf=idf/sum(sum(idf));

% Squeeze plane
% En version "de base", sans tous les algo d'amelioration
% specifique au traitement de la parole.
% : reallocation du module et de la fct...
disp('Squeezing...');
squeeze1=zeros(size(sp));
squeeze2=zeros(size(sp));
for icol=1:Nt,
  disprog(icol,Nt,10);
  for jcol=1:Nf,
    if finite(real(tf(jcol,icol))),
      jcolhat=round(real(tf(jcol,icol)));
      % jcolhat=rem(rem(jcolhat-1,Nf)+Nf,Nf)+1;
      squeeze1(jcolhat,icol)=squeeze1(jcolhat,icol) + abs(fct(jcol,icol));
      squeeze2(jcolhat,icol)=squeeze2(jcolhat,icol) + fct(jcol,icol);
    end;
  end;
end;
squeeze=(abs(squeeze2)+squeeze1)/2;
clear squeeze1 squeeze2


figure(1)
subplot(2,3,1);
plot(real(sig));
axis([1 Nt min(real(s)) max(real(s))]);
xlabel('temps');
title('(a)');

subplot(2,3,2);
imagesc(t,f,abs(ske(1:Nf/2,:)));
colormap(flipud(gray))
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(b)');

subplot(2,3,3);
% fit sur la premiere partie de la courbe
theta2=theta(1:64);
p=polyfit(1:64,theta2,1);
[ax h1 h2]=plotyy([0],[0],t,polyval(p,1:192));
set(h2,'linestyle','--');
set(ax(1),'ylim',[0 .5]);
set(ax(1),'ytick',[0 0.1 0.5]);
set(ax(2),'ylim',[-30*pi 60*pi]);
set(ax(2),'ytick',[0 10*pi 50*pi]);
set(ax(2),'yticklabels',['  0';'10p';'50p']);
set(ax(2),'fontname','symbol');
set(ax(2),'xtick',[]);
disp('frequence detecte');
p(1)/2/pi
hold on;
ax=plotyy(t,R,t,theta);
% axis([1 128 -pi pi]);
set(ax(1),'ylim',[0 .5]);
set(ax(1),'ytick',[0 0.1 0.5]);
set(ax(2),'ylim',[-30*pi 60*pi]);
set(ax(2),'ytick',[0 10*pi 50*pi]);
set(ax(2),'yticklabels',['  0';'10p';'50p']);
set(ax(2),'fontname','symbol');
set(ax(2),'xtick',[]);
hd=xlabel('temps');
set(hd,'fontname','helvetica');
hd=title('(c) - \omega=2\pi 0.1');
set(hd,'fontname','helvetica');
grid

subplot(2,3,4);
imagesc(t,f,idf(1:Nf/2,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(d)');

subplot(2,3,5);
imagesc(t,f,squeeze(1:Nf/2,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(e)');

subplot(2,3,6);
imagesc(t,f,rsp(1:Nf/2,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(f)');

% print -deps These/chap1/phfct1.ps




