function [n,t,d,f]=v_noise(N,fs,rfmin,rfmax);
% Genere un bruit gaussien de DSP approx. egale a celle theoriquement
% prevue pour le recepteur VIRGO
%
%	N  : nombre de point
%	fs : frequence d'echantillonage
%
%	n  : bruit du recepteur VIRGO
%	t  : vecteur temps
%	d  : densite spectrale theorique de puissance
%	f  : vecteur frequence
%
% Typical example: Innocent/Torresani 1,
%
% m1=10; m2=10; r=1000; 
% fmin=50; fmax=500;
% tin=.515; fs=1000;
% [tout,t,x,sref,f,nout,d] = plchirp(m1,m2,r,tin,fmax,fs);
% a=1.2*max(abs(x));
% n=v_noise(length(x),fs,fmin,fmax);
% sig=x+n;
% plot(t,real(sig)); axis([t(1) tout -a a]);
% xlabel('time (seconds)'); ylabel('amplitude');
% 

% Constantes :
% bruit thermique (miroir)
s2=0.7e-42;

if rfmin > fs/2,
 error('rfmin doit etre > fs/2');
end;

Nf=2^nextpow2(N);
randn('seed',sum(100*clock));
b=noisecg(Nf);
%plot(real(b));
%std(b).^2
bf=fft(b,Nf);
d=zeros(Nf,1);
%std(bf).^2/N
f=[(0:Nf/2-1)';(-Nf/2:-1)']/Nf*fs;
fmin=min(find(f>rfmin));
fmax=min([find(f>rfmax);Nf/2]);
bf(fmin:fmax)=sqrt(s2)*bf(fmin:fmax).*(f(fmin:fmax).^(-1/2));
d(fmin:fmax)=s2./f(fmin:fmax);
bf(1:fmin)=zeros(fmin,1); bf(fmax:Nf)=zeros(Nf-fmax+1,1);
%plot(abs(bf).^2);
%pause;
n=ifft(bf,Nf);
hold on
%plot(real(n),'r');
n=n(1:N);
t=(0:N-1)/fs;
%std(n).^2
