function [cor,maxcor]=tfmafi(tfr,iflaw,t0,trac)
% V_TFMF Time-frequency matched filter.
% [COR MAXCOR]=TFMAFI(TFR,IFLAW)
%	TFR   : time-frequency representation (with positive frequency only),
%	IFLAW : reference instantaneous frequency vector (reduced frequency),
%       T0    : coalescence time in the reference signal time frame.
%	COR, MAXCOR : time-frequency matched filter
%
% example: 
%
% E. Chassande, P. Flandrin, 1995.
% [x f]=fmlin(150,0.1,0.4);nout=150;
% xcol=length(x); 
% xsig=[zeros(200-xcol,1);x;zeros(56,1)];
% xnoi=noisecg(256);
% xsig=sigmerge(xsig,xnoi,10);
% tfr=tfrwv(xsig,1:256,256,1);
% subplot(2,1,1); plot(real(xsig));
% [mf mfpos]=v_tfmf(tfr,f,xcol);
% subplot(2,1,2); plot(mf); hold on; plot([mfpos mfpos],[0 max(mf)],'--');
% hold off

if nargin<3,
 error('TFMAFI need 3 inputs arguments');
end;
if nargin==3,
 trac=0;
end;

if trac,
 disp('Time-frequency matched filter');
end;
[tfrow,tfcol]=size(tfr);
[ifrow,ifcol]=size(iflaw);

if (ifcol~=1),
 error('IFLAW must be a column vector');
elseif any(iflaw<0) & any(iflaw>0.5),
 error('Elements of IFLAW must be between 0 and 0.5');
elseif (ifcol>tfcol),
 error('The number of column of IFLAW must be lower TFR''s one');
end;


ind=fftround(iflaw,2*tfrow);
cor=zeros(1,tfcol);

for n=1:tfcol-t0+1,
 if trac, disprog(n,tfcol-t0+1,10); end;
 D=tfr(:,n:n+ifrow-1);
 cor(t0+n-1)=trace(D(ind,:));
%if (t0+n-1>=2196)&(t0+n-1<=2198),
%  figure(1)
%  indcret=zeros(tfrow,1);
%    for m=1:tfrow; indcret(m)=min(find(D(m,:)==max(D(m,:)))); end;
%   cret=zeros(tfrow,1);
%    for m=1:tfrow; cret(m)=max(D(m,:)); end;
%   clf;imagesc(D);axis('xy');colormap(jet)
%   hold on;
%   plot(ind,'k+');
%   plot(indcret,1:tfrow,'or');   
%  hold off
%   figure(2)
%   loglog(iflaw,diag(D(ind,:)));
%   hold on
%   loglog(iflaw,iflaw.^(0.5),'b');
%   loglog(iflaw,iflaw.^(-2.3333),'r');
%   hold off
%  cor(t0+n-1),pause;
%  pause;
% end;
end

maxcor=find(cor==max(cor));
