function [f, p, pn]=hermit(order,x);
%HERMIT computes the normalized "order"-th Hermite function and 
% its associated polynomial.
%	[F P PN]=HERMIT(ORDER,T)
%
%	ORDER	: order of the Hermite function
%	X	: abscissa vector
%	F	: values of the Hermite function of order ORDER
%		  at the points definied by X
%	P	: values of the associated polynomial at the
%		  definied by X
%	PN	: vector whose elements are the coefficients of P
%
%	Example :
%	t=linspace(-10,10,100)';
%	[f p pn]=hermite(6,t);pn,
%	plot(t,f); title ('Hermite function of order 6');
%	See also

%	E. Chassande-Mottin, April 1996.
% ref: 

[xrow xcol]=size(x);
if (xrow~=1),
 error('X must have only one column');
end;
clear xrow xcol;

p0=1;
p1=[1 0];
 
if (order==0),
  pn=p0;
elseif (order==1),
  pn=p1;
elseif (order>1),
  for n=2:order
    pn=[p1 0]-(n-1)*[0 0 p0];
    p0=p1;
    p1=pn;
  end;
end;

p=polyval(pn,x');
f=p.*exp(-(x'/2).^2);
f=f/norm(f);




