% Comparaison des differents detecteurs pour le
% SIGNAL I+T signal 1

% SIGNAL
% Input parameters:
m1   = 10;    % mass of object 1, in solar masses
m2   = 1;     % mass of object 2, in solar masses
r    = 1000;  % distance binary-earth, in Mpc
tin  = 4.216; % time to coalescence, in seconds
fout = 500;   % high cut-off frequency, in Hertz (< fs/2))
fs   = 1000;  % sampling frequency, in Hertz
ts=1/fs;

% VIRGO exponents
alpha=1/4;
beta=5/8;

% total mass
M = m1 +m2;

% reduced mass
mu = 1/(1/m1 + 1/m2);

% chirp mass
calM = M^(2/5)*mu^(3/5);

% d
d = 160*3^(3/8)*calM^(-5/8);

% tout
% tout = 3*calM^(-5/3)*(fout/100)^(-8/3)
tout = (fout/(d*beta))^(1/(beta-1));

% amplitude
A = (400/3^(3/4))*1.92*10^(-23)*calM^(5/4)/r;
% A=abs(beta-1)^(1/2)*(d*beta)^((-alpha+1/2)/(beta-1));

% time vectors
t1 = (-tin:ts:0);
tcol=length(t1);
t2= (-tin:ts:-tout)';
nout=length(t2);

% waveform
x=zeros(tcol,1);
x(1:nout) = A*(abs(t2)).^(-alpha).*cos(2*pi*d*(abs(t2)).^(beta));

% instantaneous frequency
ifl  = zeros(tcol,1);
ifl(1:nout) = d*beta*(abs(t2)).^(beta-1);

% corresponding hyperbolic chirp exponents
r=(alpha-beta/2)/(beta-1);
k=beta/(beta-1);
c=-(beta-1)/beta*(d*beta)^(-1/(beta-1));
C=A*abs(beta-1)^(-1/2)*(d*beta)^((alpha-1/2)/(beta-1));

% SIGNAL
% observation
scol=4444; nz=50;
t=[-tin-ts*((scol-nz-tcol):-1:1) t1 ts*(1:nz)];
icoal=scol-nz;
sig=hilbert([zeros(scol-nz-tcol,1);x;zeros(nz,1)]);

% noise
[n dum dsp fd]=v_noise(scol,fs,ifl(1),fout);
clear dum

s=sig+n;

% REFERENCE
% on utilise la duree de la fenetre pour s'affranchir des effets
% de bord.
dt=2; hcol=dt*54+1;
tref= t1((hcol-1)/2:nout);
sref=  x((hcol-1)/2:nout);
fref=ifl((hcol-1)/2:nout);
Nr=length(sref);

% reference "whitening"
Nref=length(fd);
sref=[sref;zeros(Nref-Nr,1)];
sfref=fft(sref,Nref);
bdpas=find(dsp>0);
sfref(bdpas)=sfref(bdpas)./dsp(bdpas);
sref=ifft(sfref); 
clear Nref sfref;
sref=sref(1:Nr);

% spectrum
% Nfs=2^nextpow2(scol);
% sf=abs(ts*fft(s,Nfs)).^2;
% fsf=fs*(0:Nfs/2-1)/Nfs;
% sfap=C^2*fsf.^(-2*(r+1));
% 
% plots
% clf;
% subplot(2,2,1); plot(t,real(s));
% axis([t(1) t(scol) -max(real(s)) max(real(s))]);
% title('observation signal');
% xlabel('time (s)');
% subplot(2,2,2);
% loglog(fsf(2:Nfs/2),sf(2:Nfs/2));
% hold on
% loglog(fsf(2:Nfs/2),sfap(2:Nfs/2),'--');
% hold off
% axis([2*fs/Nfs fs/2 min(sf(2:Nfs/2)) max(sf(2:Nfs/2))]);
% title('spectrum of the observation signal');
% xlabel('frequency (Hz)');
% subplot(2,2,3); plot(tref,real(sref));
% axis([t(1) t(scol) -max(real(sref)) max(real(sref))]);
% title('reference signal');
% xlabel('time (s)');
% subplot(2,2,4); plot(tref,fref);
% axis([t(1) t(scol) 0 fs/2]);
% title('instantaneous frequency');
% xlabel('time (s)'); ylabel('frequency (Hz)');
% fprintf('Ready ? ');
% drawnow; pause;
% fprintf('Go !\n');

% DETECTION
% constantes bruit
s4=(0.7e-42)^2; %sigma^4
e=1; % exposant decroissance spectrale bruit

% tfr configuration
Nf=512;
ttfr=2:dt:scol;
tfcol=length(ttfr);
f=fs*(1:Nf/2)/Nf;
h=window(hcol,'gauss',1e-3); h=h/norm(h); % window

% time-frequency distribution
[tfr rtfr]=tfrrsp(s,ttfr,Nf,h,1);
tfr2=ts*tfr(1:Nf/2,:); rtfr2=ts*rtfr(1:Nf/2,:);

% Reassigned spectrogram is a good approx ?
% TEST 1
% time
% margt= zeros(tfcol,1);
% for n=1:tfcol,margt(n)=fs/Nf*sum(tfr2(:,n));end;
% cretet=zeros(tfcol,1);
% for n=1:tfcol,cretet(n)=fs/Nf*max(rtfr2(:,n));end;
% st=abs(s).^2;
% 
% frequency
% margf= zeros(Nf/2,1);
% for n=1:Nf/2,margf(n)=dt*ts*sum(rtfr2(n,:));end;
% cretef=zeros(Nf/2,1);
% for n=1:Nf/2,cretef(n)=dt*ts*max(rtfr2(n,:));end;
% 
% subplot(2,1,1);
% loglog(f(2:Nf/2),margf(2:Nf/2));
% hold on
% loglog(f(2:Nf/2),cretef(2:Nf/2),'-.');
% loglog(fsf(2:Nfs/2),sf(2:Nfs/2),'.');
% hold off
% axis([2*fs/Nfs fs/2 min(sf(2:Nfs/2)) max(sf(2:Nfs/2))]);
% title('Frequency marginal');
% xlabel('frequency (Hz)');
% subplot(2,1,2);
% plot(t(ttfr),margt);
% hold on
% plot(t(ttfr),cretet,'-.');
% plot(t,st,'.');
% axis([t(1) t(scol) 0 max(st)]);
% hold off
% title('Time marginal'); xlabel('Time (s)');
% 
% fprintf('Ready ? ');
% drawnow;
% fprintf('Go !\n');

% Matched filter
[mf mfpos]=mafi(s,sref,tcol-(hcol-1)/2+1,1);
mf=mf*ts^2;
mf=mf(ttfr); mfpos=mfpos/dt; % re-samplinf of mf on tfr grid.

% max(mf), norm(sref)^4*ts^2
% TF matched filter
fa=zeros(1,Nf/2);
fa(1)=0;
fa(2:Nf/2)=(fs*(1:Nf/2-1)'/Nf).^(2*(e-alpha/(beta-1)));
for n=1:tfcol,
  tfr2(:,n)=fa'.* tfr2(:,n);
 rtfr2(:,n)=fa'.*rtfr2(:,n);
end;

% TEST 2
%D=rtfr2(:,(icoal-length(fref))/dt:(icoal/dt)); %<- pas exact!
%if Nf==512;
% [a b]=meshgrid(-10:10,-10:10);
% kern=exp((-a.^2-b.^2)/(2.3)^2);
% kern=kern/sum(sum(kern));
%else
% error('Smoothing kernel size conviniant only for Nf=512');
%end;

%D=conv2(D,kern,'same');
%ind=fftround(fref(1:dt:Nr)/fs,Nf);
%clf;
%plot(fref(1:dt:Nr),diag(D(ind,:)));
%hold on
%plot(fref(1:dt:Nr),C^2*fref(1:dt:Nr).^(-2*(r+1))*(1-beta)*(d*beta)^(1/(beta-1)).*fref(1:dt:Nr).^((beta-2)/(beta-1)));
%title('Path integration'); xlabel('frequency (Hz)');
%fprintf('Ready ? ');
%%pause;
%fprintf('Go !\n');

%clf
%loglog(diag(D(ind,:)));
%hold on
%loglog((1:length(fref)).^(-2*alpha));
%plot(fref,C^2*fref.^(-2*(r+1))*(1-beta)*(d*beta)^(1/(beta-1)).*fref.^((beta-2)/(beta-1)));
%title('Path integration'); xlabel('time (s)');
%fprintf('Ready ? ');
%pause;
%fprintf('Go !\n');

%clear D ind

% spectro
[spmf  sppos]=tfmafi( tfr2,fref(1:dt:Nr)/fs,(tcol-(hcol-1)/2+1)/dt,1);
spmf =(dt*ts)*C^2*spmf/s4/(c*k*(k-1));

% smoothing
% fprintf('unsmoothed version...\n')
%rtfr2=conv2(rtfr2,kern,'same'); fprintf('\n smoothing...\n \n ');

% reass spectro
[rspmf rsppos]=tfmafi(rtfr2,fref(1:dt:Nr)/fs,(tcol-(hcol-1)/2+1)/dt,1);
rspmf=(dt*ts)*C^2*rspmf/s4/(c*k*(k-1));

mfmax=max([mf spmf rspmf]);

% axe=[t(1) t(scol) 0 mfmax];
% 
% figure(1)
% h1=subplot(4,1,1);
% plot(t,real(s));
% axis([t(1) t(scol) -max(real(s)) max(real(s))]);
% pos1=get(h1,'position');
% title('observation signal');
% set(h1,'position',pos1.*[1 1 1 .5]);
% 
% h2=subplot(4,1,2); 
% plot(t(ttfr),mf); hold on; 
% plot([t(ttfr(mfpos)) t(ttfr(mfpos))],[0 mfmax],'--');
% hold off
% axis(axe);
% title('matched filter');
% pos2=get(h2,'position');
% set(h2,'position',pos2.*[1 1 1 .5]);
% 
% h3=subplot(4,1,3); 
% plot(t(ttfr),spmf); hold on; 
% plot([t(ttfr(sppos)) t(ttfr(sppos))],[0 mfmax],'--');
% hold off
% axis(axe);
% title('path integration with spectrogram');
% pos3=get(h3,'position');
% set(h3,'position',pos3.*[1 1 1 .5]);
% 
% h4=subplot(4,1,4); 
% plot(t(ttfr),rspmf); hold on; 
% plot([t(ttfr(rsppos)) t(ttfr(rsppos))],[0 mfmax],'--');
% hold off
% axis(axe);
% title('path integration with reassigned spectrogram');
% pos4=get(h4,'position');
% set(h4,'position',pos4.*[1 1 1 .5]);
% 
% %print
% figure(2)
% axe=[t(tcol-(hcol-1)/2+1) t(scol) 0 mfmax];
% ttfr2=ttfr((tcol-(hcol-1)/2+1)/dt:tfcol);
% clf
% plot(t(ttfr2),mf((tcol-(hcol-1)/2+1)/dt:tfcol),'-.'); hold on; 
% plot(t(ttfr2),spmf((tcol-(hcol-1)/2+1)/dt:tfcol),'--'); hold on; 
% plot(t(ttfr2),rspmf((tcol-(hcol-1)/2+1)/dt:tfcol)); hold on; 
% plot([t(ttfr(mfpos)) t(ttfr(mfpos))],[0 mfmax],'--');
% hold off
% axis(axe);
% title('detector output');
% xlabel('delay (s)');
%pos2=get(h2,'position');
%set(h2,'position',pos2.*[1 1 1 .5]);

figure(1)
clf
ttfr2=ttfr((tcol-(hcol-1)/2+1)/dt:tfcol);
tps=t(ttfr2);
detect1=mf((tcol-(hcol-1)/2+1)/dt:tfcol);detect1=detect1/max(detect1);
detect2=spmf((tcol-(hcol-1)/2+1)/dt:tfcol);detect2=detect2/max(detect2);
detect3=rspmf((tcol-(hcol-1)/2+1)/dt:tfcol);detect3=detect3/max(detect3);
axe=[t(tcol-(hcol-1)/2+1) t(scol) 0 1];

plot(tps,detect1,'-.'); hold on;
plot(tps,detect2,'--'); hold on;
plot(tps,detect3); hold on;
plot([t(ttfr(mfpos)) t(ttfr(mfpos))],[0 1],'--');
hold off
axis(axe);
title('(a) - sortie du detecteur');
xlabel('retard (s)');

% print -dps These/chap4/acha5b.ps

