k = -5/3;
epsilon = 1;
fmin = 50;
fmax = 450;
umax = log(fmax/fmin);
N = 20;
M = 128;
u = linspace(-umax,umax,N+1);
du = 2*umax/(N+2);
v = linspace(du,umax,N/2+1);
vv = v(1:max(size(v))-1);
zz = ((lambda(k,vv).*lambda(k,-vv)).^(epsilon-4/3))./(diff(zeta(k,v))/du);
%zz =
((lambda(k,vv).*lambda(k,-vv)).^(epsilon-4/3));%./(diff(zeta(k,v))/du);
%zz = 1./(diff(zeta(k,v))/du);
z = [fliplr(zz) 1 zz];

zpadp = zeros(1,M);
zpadp(M/2-N/2+1:M/2+N/2+1) = z;
zzp = fftshift(zpadp);
zpf = fft(zzp);
zp = real(fftshift(zpf));

zpada = zeros(1,M);
zpada(M/2-N/2+1:M/2+N/2+1) = ones(1,N+1);
zza = fftshift(zpada);
zaf = fft(zza);
za = real(fftshift(zaf));

subplot(211)
plot(u,z);
hold on
Y = 1.2;
plot([u(1) u(N+1)],[1 1],'--')
plot([0 0],[0 Y])
hold off
axis([-umax umax 0 Y]);
xlabel('u');
ylabel('\sigma^{4}h(u)');
%title('kern(u) = (lambda(u)*lambda(-u))^(eps-4/3)/zetadot(u)');
title(['fmin = ',num2str(fmin),', fmax = ',num2str(fmax)]);

L = max(size(za));
v = linspace(-.5-1/L,.5,L);

subplot(212)
plot(v,za,'--')
hold on
plot(v,zp)%*max(max(za))/max(max(zp)))
plot([v(1) v(L)],[0 0])
axis([-.5 .5 2*min(za) 1.2*max(za)])
plot([0 0],[2*min(za) 1.2*max(za)])
xlabel('s')
ylabel('Transf. de Fourier de \sigma^{4}h')
hold off

% print -deps These/chap4/fig3.ps
