% Chapitre 3 : Forme analytique du champ de reallocation de 3 logons.
% tesselation temps-frequence


clear
% signal
te=1/5; fe=1/te;

t0=sqrt(2);
t01=sqrt(2)/1.5;
t02=1.5*sqrt(2);

% t=(-4*t0/te:4*t0/te)';
ta=(0:4*t0/te)';
t=[-flipud(ta(2:end));ta];

tps=1:length(t);
s1=exp(-(t*te+t0).^2/2).*exp(2*pi*i*0.25*t);
s2=exp(-(t*te-t0).^2/2).*exp(2*pi*i*0.25*t);
s0=s1+s2;
s1=exp(-(t*te+t01).^2/2).*exp(2*pi*i*0.25*t);
s2=exp(-(t*te-t01).^2/2).*exp(2*pi*i*0.25*t);
s01=s1+s2;
s1=exp(-(t*te+t02).^2/2).*exp(2*pi*i*0.25*t);
s2=exp(-(t*te-t02).^2/2).*exp(2*pi*i*0.25*t);
s02=s1+s2;

% fenetre
th=-63:63;h=exp(-(th*te).^2/2);

% parametre
Nre=128;
tt=te*t; ff=2*pi*fe*(-Nre/2:Nre/2-1)/Nre;

tfr0=tfrsp(s0,tps,Nre,h',1);
tfr01=tfrsp(s01,tps,Nre,h',1);
tfr02=tfrsp(s02,tps,Nre,h',1);

% keyboard;

% express. theorique du chp de vect. de realloc
N=51;
nmid=(N+1)/2;
wv=linspace(ff(1),ff(end),N);
tv=linspace(tt(1),tt(end),N);
[wm tm]=meshgrid(wv,tv);
% r =(wm+i*tm)-t0*(exp(t0*wm/2)/2+i*sinh(t0*tm/2))./(exp(t0*wm/2)/2+cosh(t0*tm/2));
r0 =-wm/2-t0/2* sin(t0*wm)./(cosh(t0*tm)+cos(wm*t0)) ...
    +i*(-tm/2+t0/2*sinh(t0*tm)./(cosh(t0*tm)+cos(wm*t0)));
r01=-wm/2-t01/2* sin(t01*wm)./(cosh(t01*tm)+cos(wm*t01)) ...
    +i*(-tm/2+t01/2*sinh(t01*tm)./(cosh(t01*tm)+cos(wm*t01)));
r02=-wm/2-t02/2* sin(t02*wm)./(cosh(t02*tm)+cos(wm*t02)) ...
    +i*(-tm/2+t02/2*sinh(t02*tm)./(cosh(t02*tm)+cos(wm*t02)));

figure(1);
clf;
% spectrogramme
subplot(2,3,1);
tfr01=[tfr01(3*Nre/4+1:Nre,:);tfr01(1:3*Nre/4,:)];
imagesc(tt,ff,tfr01);
axis([-6 6 -6 6]);
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(a)');
axis('square');
colormap(flipud(gray));

% chp de vect.
subplot(2,3,4);
quiver(tm(1:fe:end,:),wm(1:fe:end,:),imag(r01(1:fe:end,:)),real(r01(1:fe:end,:)),2)
axis([tt(1) tt(end) ff(1) ff(end)]);
title('t_0=2^{1/2}/2');
axis([-6 6 -6 6]);
xlabel('temps');
ylabel('frequence');
axis('square');

subplot(2,3,2);
tfr0=[tfr0(3*Nre/4+1:Nre,:);tfr0(1:3*Nre/4,:)];
imagesc(tt,ff,tfr0);
axis([-6 6 -6 6]);
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(b)');
axis('square');
colormap(flipud(gray));

% chp de vect.
subplot(2,3,5);
quiver(tm(1:fe:end,:),wm(1:fe:end,:),imag(r0(1:fe:end,:)),real(r0(1:fe:end,:)),2)
axis([tt(1) tt(end) ff(1) ff(end)]);
axis([-6 6 -6 6]);
title('t_0=2^{1/2}');
xlabel('temps');
ylabel('frequence');
axis('square');

% spectrogramme
subplot(2,3,3);
tfr02=[tfr02(3*Nre/4+1:Nre,:);tfr02(1:3*Nre/4,:)];
imagesc(tt,ff,tfr02);
axis([-6 6 -6 6]);
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(c)');
axis('square');
colormap(flipud(gray));

% chp de vect.
subplot(2,3,6);
quiver(tm(1:fe:end,:),wm(1:fe:end,:),imag(r02(1:fe:end,:)),real(r02(1:fe:end,:)),2)
axis([tt(1) tt(end) ff(1) ff(end)]);
title('t_0=2 2^{1/2}');
axis([-6 6 -6 6]);
xlabel('temps');
ylabel('frequence');
axis('square');

% print -deps These/chap3/logon2.ps
