% Chapitre 3, decomposition du champ de reallocation
% pour differente type de fenetre

clear
te=1/20; fe=1/te;
t=(-256:255)';
s=exp(-(1-i)*(t*te).^2/2); %.*exp(2*pi*i*0.25*t);

th1=-128:128; h1=exp(-(th1*te/2).^2/2);
th2=-128:128; h2=exp(-(th2*te).^2/2);
th3=-128:128; h3=exp(-(th3*te*2).^2/2);

xx = [0 1 .8 1 .8].';
yy = [0 0 .08 0 -.08].';
arrow = xx + yy.*sqrt(-1);

[tfa tfb tfc]=decomp(s,1:512,512,h1.',1,te);
M=2.5;
ext=round(M/te);exf=round(M/(2*pi*fe/512));
dt=round(ext/5);df=round(exf/5);
indict=256+(-ext:dt:ext);indicf=256+(-exf:df:exf+2);
t=te*(-256:255); f=2*pi*fe*(-256:255)/512;
tv=t(indict); fv=f(indicf);
tfa=[tfa(257:512,:);tfa(1:256,:)];
tfa=tfa(indicf,indict); tfa=tfa(:);
tfa=real(tfa)+i*2*pi*imag(tfa)/512;
tfb=[tfb(257:512,:);tfb(1:256,:)];
tfb=tfb(indicf,indict); tfb=tfb(:);
tfb=real(tfb)+i*2*pi*imag(tfb)/512;
tfc=[tfc(257:512,:);tfc(1:256,:)];
tfc=tfc(indicf,indict); tfc=tfc(:);
tfc=real(tfc)+i*2*pi*imag(tfc)/512;
xy=ones(length(fv),1)*tv+i*fv'*ones(1,length(tv));
xy=xy(:);
a1=arrow*tfa.'+ones(5,1)*xy.';
b1=arrow*tfb.'+ones(5,1)*xy.';
c1=arrow*tfc.'+ones(5,1)*xy.';

[tfa tfb tfc]=decomp(s,1:512,512,h2.',1,te);
M=2.5;
ext=round(M/te);exf=round(M/(2*pi*fe/512));
dt=round(ext/5);df=round(exf/5);
indict=256+(-ext:dt:ext);indicf=256+(-exf:df:exf+2);
t=te*(-256:255); f=2*pi*fe*(-256:255)/512;
tv=t(indict); fv=f(indicf);
tfa=[tfa(257:512,:);tfa(1:256,:)];
tfa=tfa(indicf,indict); tfa=tfa(:);
tfa=real(tfa)+i*2*pi*imag(tfa)/512;
tfb=[tfb(257:512,:);tfb(1:256,:)];
tfb=tfb(indicf,indict); tfb=tfb(:);
tfb=real(tfb)+i*2*pi*imag(tfb)/512;
tfc=[tfc(257:512,:);tfc(1:256,:)];
tfc=tfc(indicf,indict); tfc=tfc(:);
tfc=real(tfc)+i*2*pi*imag(tfc)/512;
xy=ones(length(fv),1)*tv+i*fv'*ones(1,length(tv));
xy=xy(:);
a2=arrow*tfa.'+ones(5,1)*xy.';
b2=arrow*tfb.'+ones(5,1)*xy.';
c2=arrow*tfc.'+ones(5,1)*xy.';

[tfa tfb tfc]=decomp(s,1:512,512,h3.',1,te);
M=2.5;
ext=round(M/te);exf=round(M/(2*pi*fe/512));
dt=round(ext/5);df=round(exf/5);
indict=256+(-ext:dt:ext);indicf=256+(-exf:df:exf+2);
t=te*(-256:255); f=2*pi*fe*(-256:255)/512;
tv=t(indict); fv=f(indicf);
tfa=[tfa(257:512,:);tfa(1:256,:)];
tfa=tfa(indicf,indict); tfa=tfa(:);
tfa=real(tfa)+i*2*pi*imag(tfa)/512;
tfb=[tfb(257:512,:);tfb(1:256,:)];
tfb=tfb(indicf,indict); tfb=tfb(:);
tfb=real(tfb)+i*2*pi*imag(tfb)/512;
tfc=[tfc(257:512,:);tfc(1:256,:)];
tfc=tfc(indicf,indict); tfc=tfc(:);
tfc=real(tfc)+i*2*pi*imag(tfc)/512;
xy=ones(length(fv),1)*tv+i*fv'*ones(1,length(tv));
xy=xy(:);
a3=arrow*tfa.'+ones(5,1)*xy.';
b3=arrow*tfb.'+ones(5,1)*xy.';
c3=arrow*tfc.'+ones(5,1)*xy.';

figure(1);
subplot(3,3,1);
plot(real(a1),imag(a1),'k-'); 
axis([-M M -M M]);
xlabel('temps');
ylabel({'(a)';'frequence'});
title('r(t,\omega)');
axis('square');

subplot(3,3,2);
plot(real(b1),imag(b1),'k-'); 
axis([-M M -M M]);
xlabel('temps');
ylabel('frequence');
title('\nabla log |F|');
axis('square');

subplot(3,3,3);
plot(real(c1),imag(c1),'k-'); 
axis([-M M -M M]);
xlabel('temps');
ylabel('frequence');
title('g(t,\omega)');
axis('square');

subplot(3,3,4);
plot(real(a2),imag(a2),'k-'); 
axis([-M M -M M]);
xlabel('temps');
ylabel({'(b)';'frequence'});
axis('square');

subplot(3,3,5);
plot(real(b2),imag(b2),'k-'); 
axis([-M M -M M]);
xlabel('temps');
ylabel('frequence');
axis('square');

subplot(3,3,6);
plot(real(c2),imag(c2),'k-'); 
axis([-M M -M M]);
xlabel('temps');
ylabel('frequence');
axis('square');

subplot(3,3,7);
plot(real(a3),imag(a3),'k-'); 
axis([-M M -M M]);
xlabel('temps');
ylabel({'(c)';'frequence'});
axis('square');

subplot(3,3,8);
plot(real(b3),imag(b3),'k-'); 
axis([-M M -M M]);
xlabel('temps');
ylabel('frequence');
axis('square');

subplot(3,3,9);
plot(real(c3),imag(c3),'k-'); 
axis([-M M -M M]);
xlabel('temps');
ylabel('frequence');
axis('square');

% print -deps These/chap3/fig3a1.ps




