clear
te=1/24; fe=1/te;
t=(-256:255)';
t01=3;
t02=round(pi/2/te);
t03=60;
s1=(t==t01)+(t==-t01);
s2=(t==t02)+(t==-t02);
s3=(t==t03)+(t==-t03);
th=-63:63;h=exp(-(th*te).^2/2);
xx = [0 1 .8 1 .8].';
yy = [0 0 .08 0 -.08].';
arrow = xx + yy.*sqrt(-1);
threshold=3e-4;

tf1=opreassp(s1,1:512,512,h.',1);
[tfr1 rtfr1]=tfrrsp(s1,1:512,512,h.',1);
tf1=tf1.*(tfr1>threshold);
tf1=[tf1(257:512,:);tf1(1:256,:)];
tf2=opreassp(s2,1:512,512,h.',1);
[tfr2 rtfr2]=tfrrsp(s2,1:512,512,h.',1);
tf2=[tf2(257:512,:);tf2(1:256,:)];
tf2=tf2.*(tfr2>threshold);
tf3=opreassp(s3,1:512,512,h.',1);
[tfr3 rtfr3]=tfrrsp(s3,1:512,512,h.',1);
tf3=[tf3(257:512,:);tf3(1:256,:)];
tf3=tf3.*(tfr3>threshold);

Mt=5; Mf=2;
ext=round(Mt/te);exf=round(Mf/(2*pi*fe/512));
dt=round(ext/5);df=round(exf/5);
indict=256+(-ext:dt:ext);indicf=256+(-exf:df:exf+2);
t=te*(-256:255); f=2*pi*fe*(-256:255)/512;

tv=t(indict); fv=f(indicf);
xy=ones(length(fv),1)*tv+i*fv'*ones(1,length(tv));
xy=xy(:);

tf1=tf1(indicf,indict); tf1=tf1(:);
tf1=real(tf1)*te+i*2*pi*imag(tf1)*fe/512;
a1=arrow*tf1.'+ones(5,1)*xy.';

tf2=tf2(indicf,indict); tf2=tf2(:);
tf2=real(tf2)*te+i*2*pi*imag(tf2)*fe/512;
a2=arrow*tf2.'+ones(5,1)*xy.';

tf3=tf3(indicf,indict); tf3=tf3(:);
tf3=real(tf3)*te+i*2*pi*imag(tf3)*fe/512;
a3=arrow*tf3.'+ones(5,1)*xy.';

figure(1);
subplot(2,3,1);
plot(t,s1,'k-'); 
axis([-Mt Mt 0 1]);
xlabel('temps');
title(['t_0=',num2str(t01*te)]);
axis('square');

subplot(2,3,2);
plot(t,s2,'k-'); 
axis([-Mt Mt 0 1]);
xlabel('temps');
title(['t_0 \approx \pi/2']);
axis('square');

subplot(2,3,3);
plot(t,s3,'k-'); 
axis([-Mt Mt 0 1]);
xlabel('temps');
title(['t_0=',num2str(t03*te)]);
axis('square');

subplot(2,3,4);
imagesc(t,f,tfr1);
axis('xy');
colormap(flipud(gray));
axis([-Mt Mt -Mf Mf]);
xlabel('temps');
ylabel('frequence');
axis('square');

subplot(2,3,5);
imagesc(t,f,tfr2);
axis('xy');
colormap(flipud(gray));
axis([-Mt Mt -Mf Mf]);
set(gca,'ytick',[-2 -1 0 1 2]);
grid on;
xlabel('temps');
ylabel('frequence');
axis('square');

subplot(2,3,6);
imagesc(t,f,tfr3);
axis('xy');
colormap(flipud(gray));
axis([-Mt Mt -Mf Mf]);
xlabel('temps');
ylabel('frequence');
axis('square');

% print -dps These/chap2/fig2f.ps

%figure(2);
%subplot(2,3,1);
%plot(real(a1),imag(a1),'k-'); 
%axis([-Mt Mt -Mf Mf]);
%xlabel('temps');
%ylabel('frequence');
%axis('square');

%subplot(2,3,2);
%plot(real(a2),imag(a2),'k-'); 
%hold on
%plot(0,1,'o');
%plot(0,-1,'o');
%hold off
%axis([-Mt Mt -Mf Mf]);
%set(gca,'ytick',[-2 -1 0 1 2]);
%grid on;
%xlabel('temps');
%ylabel('frequence');
%axis('square');

%subplot(2,3,3);
%plot(real(a3),imag(a3),'k-'); 
%axis([-Mt Mt -Mf Mf]);
%xlabel('temps');
%ylabel('frequence');
%axis('square');

%subplot(2,3,4);
%imagesc(t,f,rtfr1);
%axis('xy');
%colormap(flipud(gray));
%axis([-Mt Mt -Mf Mf]);
%xlabel('temps');
%ylabel('frequence');
%axis('square');

%subplot(2,3,5);
%imagesc(t,f,displog(rtfr2,-10));
%axis('xy');
%colormap(flipud(gray));
%axis([-Mt Mt -Mf Mf]);
%set(gca,'ytick',[-2 -1 0 1 2]);
%grid on;
%xlabel('temps');
%ylabel('frequence');
%axis('square');

%subplot(2,3,6);
%imagesc(t,f,rtfr3);
%axis('xy');
%colormap(flipud(gray));
%axis([-Mt Mt -Mf Mf]);
%xlabel('temps');
%ylabel('frequence');
%axis('square');

%% print -dps These/chap2/fig2h.ps

