clear
m1=10; m2=10; r=1000; 
fmin=50; fmax=500;
tin=.515; fs=1000;
[tout,t,x,sref,f,nout,d] = plchirp(m1,m2,r,tin,fmax,fs);
x=hilbert([x;zeros(100,1)]/norm(x));
t=[t (1:100)/fs];

f=[f(1:nout);NaN*ones(length(x)-nout,1)];
h=roundwin(256);

xout=nout+80; Nf=128;
[sp rsp]=tfrrsp(x,1:4:xout,2*Nf,h,1);
wv=tfrwv(x,1:4:xout,Nf,1);
fsp=(1:Nf)/(2*Nf);
ttf=t(1:4:xout);

% fplotmax=500;
% findicmax=min(find((fsp*fs)>=fplotmax));

subplot(2,3,1);
imagesc(ttf*fs,fsp,sp(1:Nf,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(a)');

wv=wv.*(wv>0);
subplot(2,3,2);
imagesc(ttf*fs,fsp,wv);
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(b)');

subplot(2,3,3);
imagesc(ttf*fs,fsp,rsp(1:Nf,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(c)');


s=fmsin(128);
t=128; f=(1:128)/256;
[sp rsp]=tfrrsp(s,1:128,256,h,1);
wv=tfrwv(s,1:128,128,1);

subplot(2,3,4);
imagesc(t,f,sp(1:128,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(d)');

wv=wv.*(wv>0);
subplot(2,3,5);
imagesc(t,f,wv);
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(e)');

subplot(2,3,6);
imagesc(t,f,rsp(1:128,:));
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(f)');

colormap(flipud(gray));

% print -deps These/chap1/fiac.ps


