function [w, l]=ROUNDWIN(n,k);
% [W, L]=ROUNDWIN(N,K) compute the length of the Gaussian
% window which is circular for a given discretization
% of the time-frequency plane.
%
%	N : number of frequency bins,
%	K : complementary parameter for WINDOW procedure,
%	(default: K=1e-3)
%	L : resulting window length,
%	W : associated Gaussian window.
%
% Example :
% w=roundwin(512); plot(w); 
%
% Proof :
% w(t)=exp(-Pi*(t/T)^2)
% circular => T=sqrt(N)
% w(L/2)=K => L=2*sqrt(-N/pi log(K))
%
% see also: TFRRSP, and all the time-frequency representations listed in
% the file TFRLIST

% E. Chassande-Mottin, February 1997
% Please send any error you find or any comment
% via e-mail to : 

if nargin==1,
 k=1e-3;
end;

l=floor(sqrt(-n*log(k)/pi))+1;
w=amgauss(2*l+1,l+1,sqrt(n));
