function [cor,maxcor]=mf(s,ref,t0,trac);
% Virgo signal detection
% MF Matched filter detector
% MF computes the matched filter detector.
% [COR MAXCOR]=MF(S,REF)
%	S   : signal,
%	REF : reference signal,
%	T0  : coalescence time in the reference signal time frame.
%	COR : matched filter output,
%	MAXCOR : detected time of coalescence.
%
% example: 
% [tout,t,x,f,d,nout] = plchirp2(1,10,200,.150,400,1000);
% x=hilbert(x/norm(x)); xcol=length(x); 
% xsig=[zeros(200-xcol,1);x;zeros(56,1)];
% xnoi=noisecg(256);
% xsig=sigmerge(xsig,xnoi,10);
% rcol=50; xref=x(nout-rcol+1:nout);
% subplot(2,1,1); plot(real(xsig));
% [mf mfpos]=v_mf(xsig,xref,1+xcol-(nout-rcol+1));
% subplot(2,1,2); plot(mf); hold on; plot([mfpos mfpos],[0 max(mf)],'--');
% hold off

if nargin<3,
 error('MAFI need 3 inputs arguments');
end;
if nargin==3,
 trac=0;
end;

if trac,
 disp('Matched filter');
end;

[ls scol]   = size(s);
[lref rcol] = size(ref);

if (scol~=1),
 error('S must be a column vector');
end;

if (rcol~=1),
 error('REF must be a column vector');
end;

cor=zeros(1,ls);
for i=1:ls-t0+1,
 if trac, disprog(i,ls-t0+1,10); end;
 cor(t0+i-1)=abs(s(i:i+lref-1)'*ref).^2;
end

maxcor=find(cor==max(cor));


