function [c1, c2, c3] = criteria(tfr,f,N,iflaw,E);
%CRITERIA computes an objective criteria to quantify
%the quality of a representation. It mixes a measurement 
%of the flatness of noise energy distribution and an
%evaluation of energy in the signal+noise region.
% Function used by chap3/super4.m
%
%	 TFR   : time-frequency representation.
%	 N     : number of frequency bins
%        IFLAW : theoric instantaneous frequency
%	 E     : signal energy
%
%	Example :
% 
%	See also all the time-frequency representations listed in
%	the file CONTENTS (TFR*)

%	E. Chassande-Mottin, F. Auger, March 1996.

[tfrow,tfcol] = size(tfr);
[ifrow,ifcol] = size(iflaw);

if (ifcol~=1),
 error('IFLAW must only have one column');
 elseif tfcol~=ifrow,
 error('The number of column of TFR and the number of row of IFLAW must be equal');
 elseif (N<=0),
 error('N must be greater than zero'); 
end; 
clear tfrow tfcol ifrow ifcol

c1=0;
for delta=-1:1,
 indice=fftround(iflaw,N)-f(1)+1+delta; 
 t=1:length(indice);
 t=t((indice>0)&(indice<=N/2));
 indice=indice((indice>0)&(indice<=N/2));
 for n=1:length(indice);
   c1=c1+tfr(indice(n),t(n));
   tfr(indice(n),t(n))=nan;
 end;
end;
c1=abs(c1/N-E)/E,

%flatness
tfr=tfr(finite(tfr));
tfr=tfr(:);
% Statisque d'ordre 2 : variance de la repartition
% des valeurs de la distrib. dans la zone bruit seul.
% c2=sqrt(cov(tfr(:))),
% Statisque d'ordre 4 standardisee : kurtosis
% des valeurs de la distrib. dans la zone bruit seul.
Ntfr=length(tfr);
m1=mean(tfr);
m4=sum((tfr-m1).^4)/Ntfr;
m2=sum((tfr-m1).^2)/Ntfr;
k4=Ntfr^2/((Ntfr-1)*(Ntfr-2)*(Ntfr-3))*((Ntfr+1)*m4-3*(Ntfr-1)*m2^2);
k2=Ntfr/(Ntfr-1)*m2;
c2=k4/k2^2,

% Entropie
Nc=50;
h=tfr/sum(tfr);h=h(h>0);
c3=-sum(h.*log(h))/log(Ntfr),
