function [t,x,f,slope,crit1,crit2] = apphst(alpha,beta,d,A,tin,fout,fs,dr);
% ************* Figures 2 a 4 *************
% PLCFIG evaluates the waveform of a chirp using the
% following definition:
%    x(t) = A |t|^(-alpha) cos(2 pi d |t|.^(beta))
%
% Input parameters:
% alpha= enveloppe exponent
% beta = instantaneaous frequency exponent
% d    = modulation rate
% A    = amplitude
% tin  = time to coalescence, in seconds
% fout = high cut-off frequency, in Hertz (< fs/2))
% fs   = sampling frequency, in Hertz
% dr   = dynamical range (optional)
%        dr=0 : no display
%        dr~=0 display (signal, inst. freq., stat. phase approx)
%        dr is used for the last plot.
% Output parameters:
% tout = time at which fout is reached, in seconds
% t    = time vector, in seconds
% x    = waveform
% f    = instantaneous frequency of x, in Hertz
% slope= theoretical slope for the spectrum in a log-log plot
%        predicted by the phase stat. approximation
% crit1= constant in Harthong criterion for phase stat. approximation
% crit2= constant in heuristic criterion for phase stat. approximation
%        the complete criterion is
%          critere{1/2}=crit{1/2} * f^(-beta/(beta-1)) * (beta d)^(1/(beta-1))
%
% Example :
% [t,x,f,slope] = plcfig(0.15,0.85,100,1,4,250,2500,40);
%

%  P. Flandrin, 05/12/97. Last modification 05/19/97.
%  E. Chassande-Mottin, 5/3/98
%

d = abs(d)*sign(beta);

ts = 1/fs;

%if beta<0,
% error('BETA must be a positive number');
%elseif beta<1,
 tout=(fout/abs(d*beta))^(1/(beta-1));
%else
% tin =(fout/abs(d*beta))^(1/(beta-1));
% tout=ts;
%end;

%tout = 0;

%t = (-tin:ts:0);
%t = fliplr((-tout:-ts:-ts*floor(tin/ts)));
Npoints = 2^(nextpow2(floor((tin-tout)/ts)));
t = fliplr(-tout-ts*(0:Npoints-1));
tcol=length(t);
x=zeros(tcol,1);
%t2= (-tin:ts:-tout);
%nout=length(t2);
%x(1:nout) = A*(abs(t2)).^(-alpha).*cos(2*pi*d*(abs(t2)).^(beta)+pi/4);
x(1:tcol) = A*(abs(t)).^(-alpha).*exp(-i*2*pi*d*(abs(t)).^(beta));

%if (beta>0)|(alpha>0),
% x(nout)=0;
%end;

% instantaneous frequency
f  = zeros(tcol,1);
%f(1:nout)  = beta*d*(abs(t2)).^( beta-1);
f(1:tcol)  = beta*d*(abs(t)).^( beta-1);

slope=-(alpha-1+beta/2)/(beta-1);

% display
if dr~=0,
 xnorm = x;% x/max(max(x));
 T = length(xnorm);
 N = nextpow2(T); % ceil(log2(T));
 fxnorm = fft(xnorm,2^N);
 freq = linspace(0,fs/2,2^(N-1)+1);
 spec = abs(fxnorm(1:2^(N-1)+1)).^2;
 spec = spec/max(max(spec));
 l    = length(freq);

 % plot of the waveform
 %subplot(3,1,1)
 %plot(t,real(x))
 %hold on
 %plot([t(1) 0],[0 0])
 %grid;
 %hold off
 %title(['alpha = ',num2str(alpha),' ; beta = ',num2str(beta),' ; d =
',num2str(d),' ; fout = ',num2str(fout),' ; fs = ',num2str(fs)]);
 %xlabel('time (s)')
 %ylabel('amplitude')
 %a = 1.2*max(abs(x));
 %axis([t(1) -tout -a a]);

 % plot of the instantaneous frequency
 %subplot(4,1,2)
 %plot(t,f)
 %title('instantaneous frequency')
 %xlabel('time (s)')
 %ylabel('frequency (Hz)')
 %axis([t(1) 0 0 fout]);

 % plot of the stationary phase approximation of the spectrum
 subplot(2,1,1)
 fmin = min(f(f>freq(2)));fmax = min(max(f),fs/2);
 indfmin = min(find(freq>=fmin));indfmax = min(find(freq>=fmax));
 fc = min(find(freq > sqrt(fmin*fmax)));
 specd = (log10(spec(fc)))*10-(log10(fmax)-log10(fmin))*10*slope;
 specf = (log10(spec(fc)))*10+(log10(fmax)-log10(fmin))*10*slope;
 semilogx([fmin fmin],[-dr specd],'r');
 hold on
 semilogx([fmax fmax],[-dr specf],'r');
 semilogx([fmin fmax],[specd specf],'r')
 % semilogx([freq(fc) freq(fc)],10*[log10(spec(fc)) log10(spec(fc))],'*');
 %title('normalized energy spectrum')
 title(['(o) alpha = ',num2str(alpha),' ; beta = ',num2str(beta),' ; d =
',num2str(d)]);%,' ; fout = ',num2str(fout),' ; fs = ',num2str(fs)]);
 xlabel('frequency (Hz)')
 ylabel('PSD (dB)')
% keyboard

% plot of the spectrum
 semilogx(freq(2:l),10*log10(spec(2:l)),'--');
 semilogx(freq(indfmin:indfmax),10*log10(spec(indfmin:indfmax)));
 axis([10 fs/2 -dr 0]);
 hold off

% plot of criteria
 subplot(2,1,2);
 crit1=(5/48/pi)*(12*alpha.^2-12*alpha+12*alpha*beta+2*beta^2-5*beta+2)/(beta-1)
;
 d0=d*beta;
 critere1 = abs(crit1*freq.^(-beta/(beta-1))*d0^(1/(beta-1)));
 crit2 = max(alpha,abs(beta-1))/(2*pi);
 critere2 = abs(crit2*freq.^(-beta/(beta-1))*d0^(1/(beta-1)));
 semilogx(freq(indfmin:indfmax),critere1(indfmin:indfmax));
 grid on
 hold on
 semilogx(freq(indfmin:indfmax),critere2(indfmin:indfmax),'--');
 %semilogx([fcrit fcrit],[critere(1) critere(l)],'--');
 axis([10 fs/2 0 min(1,max(max(critere1),max(critere2)))]);
 hold off
 %title('validity criteria for the stationary phase argument')
 ylabel('criteria')
 xlabel('frequency (Hz)')
end;