% GRWAVE.M
%
% P. Flandrin, 05/12/97. Last modification 05/19/97.
%
% This program plots the waveform of a gravitational
% wave expected to be radiated by a coalescing binary
% in a Newtonian approximation, its instantaneous 
% frequency and its normalized energy spectrum
% (together with its stationary phase approximation).
%
% It makes use of PLCHIRP.M

% input parameters
m1 = 10;     % mass of object 1, in solar masses
m2 = 1;     % mass of object 2, in solar masses
r =  200;     % distance binary-earth, in Mpc
tin = 4.215;     % time to coalescence, in seconds
fout = 500;  % high cut-off frequency, in Hz
fs = 2000;   % sampling frequency, in Hz
dr = 40;     % dynamic range of the energy spectrum, in dB

% waveform and instantaneous frequency
[tout,t,x,dum,f,nout,d,slope] = plchirp(m1,m2,r,tin,fout,fs);
clear dum;

% evaluation of the normalized energy spectrum
xnorm = x/max(max(x));
T = max(size(xnorm));
N = ceil(log2(T));
fxnorm = fft(xnorm,2^N);
freq = linspace(0,fs/2,2^(N-1)+1);
spec = abs(fxnorm(1:2^(N-1)+1)).^2;
spec = spec/max(max(spec));
l = max(size(freq));

% plot of the waveform
figure(1);
subplot(411)
plot(t,x)
hold on
plot([-tin 0],[0 0])
hold off 
title(['(a) - gravitational wave (m1 = ',num2str(m1),', m2 = ',num2str(m2),', r = ',num2str(r),' Mpc)'])
xlabel('time (seconds)')
ylabel('amplitude')
a=1.2*max(abs(x));
axis([-tin 0 -a a]);

% plot of the instantaneous frequency
subplot(412)
plot(t,f)
title('(b) - instantaneous frequency')
xlabel('time (seconds)')
ylabel('frequency (Hertz)')
axis([-tin 0 0 fout]);

% plot of the spectrum
%subplot(413)
%semilogx(freq(2:l),10*log10(spec(2:l)));
%axis([1 fs/2 -dr 0]);
%hold on

% plot of the stationary phase approximation of the spectrum
%fc = min(find(freq > sqrt(f(1)*fout)));
%specd = (log10(spec(fc)))*10-(log10(f(1))-log10(fout))*10*slope;
%specf = (log10(spec(fc)))*10+(log10(f(1))-log10(fout))*10*slope;
%semilogx([f(1) f(1)],[-dr specd]);
%semilogx([fout fout],[-dr specf]);
%semilogx([f(1) fout],[specd specf])

% plot of the stationary phase approx 2
%indice1=max(find(freq<f(1)));
%indice2=min(find(freq>fout))-50;
%lfv=log10(freq(indice1:indice2)); 
%lsp=10*log10(spec(indice1:indice2));
%p=polyfit(lfv,lsp',1)
%-10*2*7/6
%specap=polyval(p,lfv);
%semilogx(freq(indice1:indice2),specap,'r');
%hold off
%title('normalized energy spectrum')
%xlabel('frequency')
%ylabel('dB')

%subplot(111)
%figure(2)
% critere valid. approx ph. stat.

d0=d*5/8;
critere=115/576*freq.^(5/3)/(d0^(8/3)*pi);
indiccrit=max(find(critere<0.1));

fcrit=freq(indiccrit);

% plot of the spectrum
subplot(413)
semilogx(freq(2:l),10*log10(spec(2:l)));
axis([1 fs/2 -dr 0]);
hold on

% plot of the stationary phase approximation of the spectrum
fc = min(find(freq > sqrt(f(1)*fout)));
specd = (log10(spec(fc)))*10-(log10(f(1))-log10(fout))*10*slope;
specf = (log10(spec(fc)))*10+(log10(f(1))-log10(fout))*10*slope;
semilogx([f(1) f(1)],[-dr specd],'--');
semilogx([fout fout],[-dr specf],'--');
semilogx([f(1) fout],[specd specf],'--');
axe=axis;
%semilogx([fcrit fcrit],[axe(3) axe(4)],'--');
hold off
title('(c) - normalized energy spectrum and stationary phase approximation')
xlabel('frequency')
ylabel('dB')

subplot(414)
semilogx(freq,critere);
grid
hold on
%semilogx([fcrit fcrit],[critere(1) critere(l)],'--');
axis([1 fs/2 0 critere(l)]);
hold off
title('(d) - validity criterion for the stationary phase argument')
xlabel('frequency')

approxcrit=specd+(specf-specd)*(log10(fcrit)-log10(f(1)))/(log10(fout)-log10(f(1)))
valuecrit =10*log10(spec(indiccrit))
valuecrit-approxcrit

h=get(gcf,'children');
for ax=1:length(h);
 taille=get(h(ax),'position');
 set(h(ax),'position',taille.*[1 1 1 0.5]);
end;
