% Courbes COR du detecteur de la supervision
% Genere le fichier super3.mat utilise ensuite par super3fig.m

clear

[s iflaw]=fmlin(128,0,0.5);
t=64-32:64+31;f=1:64;N=128;
Nt=length(t); Nf=length(f);

Nrsb=[-7 0 7 13 20];

Nseuil=50;

pfa=zeros(Nseuil,Nrsb);
pdc=zeros(Nseuil,Nrsb);

Nreal=20;
[tfr1, tfr2, tfr3, d, ks] = tfrsrsp(s,t,f,N,9:4:125,15,'gauss',1e-3,1);  
clear tfr1 tfr2 tfr3 d;

ks=ks(:);
kbl=zeros(Nt*Nf,Nrsb);

for ireal=1:Nreal,
 b=noisecg(128);
 for irsb=1:Nrsb,
  sig=sigmerge(s,b,rsb(irsb));
  [tfr1, tfr2, tfr3, d, kb] = tfrsrsp(sig,t,f,N,9:4:125,15,'gauss',1e-3,1);
  clear tfr1 tfr2 tfr3 d;
  kbl(:,irsb)=kb(:); 
 end;

 smin=min(min(min(kbl(finite(kbl)))),min(ks(finite(ks)))); 
 smax=max(max(max(kbl(finite(kbl)))),max(ks(finite(ks))));
 seuil=linspace(smin,smax,Nseuil);
 for is=2:Nseuil-1,
  pdc(is,:)=pdc(is,:)+((ks<seuil(is))'*(kbl<seuil(is)))./sum(ks<seuil(is));
  pfa(is,:)=pfa(is,:)+((ks>=seuil(is))'*(kbl<seuil(is)))./sum(ks>=seuil(is));
 end;
end;

pfa=pfa/Nreal;
pdc=pdc/Nreal;
pfa(Nseuil,:)=ones(1,Nrsb);
pdc(Nseuil,:)=ones(1,Nrsb);

clf;
plot(pfa(:,2:2:10),pdc(:,2:2:10));
hold on;
paf=pfa';pcd=pdc';
plot(paf(:,2:2:50),pcd(:,2:2:50),'--');
axis('square');axis([0 1 0 1]); grid;
set(gca,'xtick',[0 0.2 0.4 0.6 0.8 1]);
set(gca,'ytick',[0 0.2 0.4 0.6 0.8 1]);
xlabel('fausse alarme'); ylabel('detection correcte');

save These/chap3/super3 pfa pdc
