% Fusion 

% Mode d'emploi : executer merging2fig.m
% puis merging3*.m

figure(1)
clf

fprintf('************************************\n');
fprintf('   Distance entre noeuds\n');
fprintf('************************************\n');

[dum deltat]=loctime(h); [dum deltaf]=locfreq(h);
center3=real(center)/deltat+i*imag(center)/Nre/deltaf;
dist=abs(center3(graphconnex(:,1))-center3(graphconnex(:,2)));

fprintf('************************************\n');
fprintf('   Fusion...\n');
fprintf('************************************\n');


%% FUSION 4 : Critere courant est 
crit=crfront;

part3=part; % part3: carte tf finale

connex=graphconnex;
[ncx mcx]=size(connex);
fprintf(' Connexite ++++\n');
for ncol=1:ncx,
  fprintf('Noeud %2.0f -> Noeud %2.0f = %3.2f\n'...
      ,connex(ncol,1),connex(ncol,2),dist(ncol)); 
end;

fprintf(' Critere ++++\n');
for ncol=1:ncx,
  fprintf('Noeud %2.0f = %3.2f\n',ncol,crit(ncol)); 
end;

borne=0.5;
indicmvcp=find(crit>borne); % mauvaise partition
nmvcp=length(indicmvcp);
center3=center2;

for ncol=1:nmvcp,
  nmerg1=connex(indicmvcp(ncol),1);  
  nmerg2=connex(indicmvcp(ncol),2);  
  indic=find(part3==nmerg2);
  part3(indic)=nmerg1*ones(size(indic)); % fusion
  indicnom=find(connex==nmerg2);
  connex(indicnom)=nmerg1*ones(size(indicnom)); 
  center3(nmerg1)=(center3(nmerg1)+center3(nmerg2))/2;
  center3(nmerg2)=0;
end;

figure(2);
subplot(2,2,4);
image(1:length(tps),f,5*part3(1:Nre/2,:));
axis('xy');
hold on;
% Numero de composante et limites
for ncol=1:npart,
  if (center3(ncol)~=0),
    plot(real(center3(ncol)),  imag(center3(ncol))/Nre,'+');
    text(real(center3(ncol))+3,imag(center3(ncol))/Nre-0.03,num2str(ncol));
    contour(1:length(tps),f,part3(1:Nre/2,:)==ncol,1,'k--');
  end;
end;
hold off
colormap(flipud(gray));
xlabel('temps');
ylabel('frequence');
title('(d)');

% print -deps These/chap3/merging3.ps




