% Fusion 

% Mode d'emploi : executer merging2fig.m
% puis merging3*.m

figure(1)
clf

fprintf('************************************\n');
fprintf('   Distance entre noeuds\n');
fprintf('************************************\n');
 
connex=graphconnex;
[dum deltat]=loctime(h); [dum deltaf]=locfreq(h);
center3=real(center)/deltat+i*imag(center)/Nre/deltaf;
dist=abs(center3(graphconnex(:,1))-center3(graphconnex(:,2)));

fprintf('************************************\n');
fprintf('   Fusion...\n');
fprintf('************************************\n');

%% FUSION 2 : Critere courant est dspe
crit=dspe(1:npart);
borne=.1;
[dum ordre]=sort(dist); clear dum;
branche=1;
part3=part; % part3: carte tf finale

[ncx mcx]=size(connex);
fprintf(' Connexite ++++\n');
for ncol=1:ncx,
  fprintf('Noeud %2.0f -> Noeud %2.0f = %3.2f\n'...
      ,connex(ncol,1),connex(ncol,2), dist(ncol)); 
end;
fprintf(' Critere   ++++\n');
for ncol=1:npart,
  fprintf('Noeud %2.0f = %3.2f\n',ncol,crit(ncol)); 
end;

nplot=1;
while any(crit>borne),
  if (crit(connex(ordre(branche),1))>borne)|(crit(connex(ordre(branche),2))>borne),
    fprintf('\nFusion Noeud %2.0f - Noeud %2.0f\n',connex(ordre(branche),1),connex(ordre(branche),2));
    fusionstring=['Fusion Comp. ' num2str(connex(ordre(branche),1)) ' - Comp. ' ...
	  num2str(connex(ordre(branche),2))];
    
    indic=find(part3==connex(ordre(branche),2));
    part3(indic)=connex(ordre(branche),1)*ones(size(indic)); % fusion
    masc=(part3==connex(ordre(branche),1));
    yrec=tffilter(masc,x(tps),1:length(tps),0);
    % [tfrrec tmes fmes]=tfrsp(y(:,npart),1:length(tps),Nre,h,1);
    % df=fmes(2)-fmes(1); clear tmes fmes; dt=1; d=dt*df; 

    % Information
    % Masque surechantillonnne
    masc4=zeros(N,length(tps));
    fact=N/Nre;
    for jcol=1:Nre,
      nres=fact*(jcol-1)+1;
      masc4(nres:nres+3,:)=ones(fact,1)*masc(jcol,:);
    end;
    tfrrec=tfrsp(yrec,1:length(tps),N,h,0);

    % Calcul encombrement
    % [tv fv]=meshgrid(t2,f2(1:N/2));
    df=f2(2)-f2(1); dt=1; d=dt*df; 
    crit(connex(ordre(branche),1))=d*sum(sum(tfrrec(1:N/2,:).*(1-masc4(1:N/2,:))))/norm(yrec)^2;
    crit(connex(ordre(branche),2))=0;
    center3(connex(ordre(branche),1))= ...
	(center3(connex(ordre(branche),1))+center3(connex(ordre(branche),2)))/2;
    center3(connex(ordre(branche),2))=0; % ce noeud n'interviendra plus.
    indicnom=find(connex==connex(ordre(branche),2));
    % keyboard;
    connex(indicnom)=connex(ordre(branche),1)*ones(size(indicnom));
    % nettoyage graphe connexite
    indicnom=find(connex(:,1)==connex(:,2)); % supprime connoxion 1-2
    connex(indicnom,:)=[];
    % reordonne
    indicnom=find(connex(:,2)<connex(:,1));
    if ~isempty(indicnom),
      temp=connex(indicnom,2);
      connex(indicnom,2)=connex(indicnom,1);
      connex(indicnom,1)=temp; clear temp;
    end;
    [ncx mcx]=size(connex); % supprime les doublons
    lignesupprim=[];
    for ncol=1:ncx,
      indicnom= ...
	  find((connex(:,1)==connex(ncol,1))&(connex(:,2)==connex(ncol,2)));
      if (length(indicnom)>1),
	lignesupprim=[lignesupprim indicnom(2:end)];
      end;
    end;
    if ~isempty(lignesupprim),
      lignesupprim=sort(lignesupprim);
      lignesupprim=lignesupprim(logical([1 diff(lignesupprim)]));
      connex(lignesupprim,:)=[];
    end;
    
    % distance
    dist=abs(center3(connex(:,1))-center3(connex(:,2)));
    [dum ordre]=sort(dist); clear dum;
    [ncx mcx]=size(connex);
    fprintf(' Connexite ++++\n');
    for ncol=1:ncx,
      fprintf('Noeud %2.0f -> Noeud %2.0f = %3.2f\n'...
      ,connex(ncol,1),connex(ncol,2), dist(ncol)); 
    end;
    fprintf(' Critere   ++++\n');
    for ncol=1:npart,
      fprintf('Noeud %2.0f = %3.2f\n',ncol,crit(ncol)); 
    end;

    figure(1);
    subplot(1,3,nplot);
    image((1:length(tps))/deltat,f/deltaf,5*part3(1:Nre/2,:));
    hold on;
    for ncol=1:ncx,
      plot([center3(connex(ncol,1)) center3(connex(ncol,2))],'k');
    end;
    hold off;
    title(fusionstring);
    nplot=nplot+1;
    axis('xy');
    pause
    branche=1;  
  else
    branche=branche+1;
  end;
end;

figure(2);
subplot(2,2,2);
image(1:length(tps),f,5*part3(1:Nre/2,:));
axis('xy');
hold on;
% Numero de composante et limites
for ncol=1:npart,
  if (center3(ncol)~=0),
    plot(real(center3(ncol))*deltat,  imag(center3(ncol))*deltaf,'+');
    text(real(center3(ncol))*deltat+3,imag(center3(ncol))*deltaf-0.03,num2str(ncol));
    contour(1:length(tps),f,part3(1:Nre/2,:)==ncol,1,'k--');
  end;
end;
hold off
colormap(flipud(gray));
xlabel('temps');
ylabel('frequence');
title('(b)');

