% CHAPITRE 3
% Illustration de mauvaise partition du plan temps-frequence
% Calcul des valeurs du tableau 3.1

Nre=64;
N=256;
fmin=0; fmax=0.5;
long1=71; long2=47;
T1=sqrt(-pi/log(1e-3))*(long1+1)/2;
T2=sqrt(-pi/log(1e-3))*(long2+1)/2;
logon1=amgauss(long1,(long1+1)/2,T1);
logon2=1/sqrt(2)*amgauss(long2,(long2+1)/2,T2);

% Parametres reglables (ecart temp., phase) 
T=16;
PHI=linspace(-pi,pi,20);
PHI=PHI(7); % choix de la phase

Nc=3; % Nombre de 

t0=ceil(sqrt(Nre)*sqrt(-log(1e-3)/pi));
h=amgauss(2*t0+1,t0+1,sqrt(Nre));
h=h/norm(h);
[dum deltat]=loctime(h); [dum deltaf]=locfreq(h);

% Information de reference
logonref=h;                         % sqrt(Nre) pour obtenir le quantum d'info
longref=2*t0+1;                     % pour le spectro
xref=zeros(2*longref+1,1);
tps=longref+1+(-31:32);
mid1=longref+1;
xref(mid1+(-(longref-1)/2:(longref-1)/2))=xref(mid1+(-(longref-1)/2:(longref-1)/2))+logonref;
xref=xref.*exp(2*pi*i*0.25*(1:2*longref+1)');

[tfrref tref fref]=tfrsp(xref,tps,N,h);
irefsp=renyi2(tfrref,tref,fref,1), % en fait, c'est 1/log(2) 

tps=2*long1+1+(-31:32);

% for tcol=1:length(T),
% for pcol=1:length(PHI),

% Signal
Trow=T; % (tcol);
x=zeros(4*long1+1,1);
mid1=2*long1+1+ceil(Trow/2); 
mid2=2*long1+1-floor(Trow/2);
x(mid1+(-(long1-1)/2:(long1-1)/2))=x(mid1+(-(long1-1)/2:(long1-1)/2))...
    +logon1.*fmlin(long1,fmin,fmax,(long1+1)/2-ceil(Trow/2))*exp(i*PHI); 
% PHI(pcol);
original=x(tps);
x(mid2+(-(long2-1)/2:(long2-1)/2))=x(mid2+(-(long2-1)/2:(long2-1)/2))...
    +logon2.*fmlin(long2,fmin,fmax,(long2+1)/2+floor(Trow/2));


[tfr2 t2 f2]=tfrsp(x,tps,N,h);
% Reallocation
[part center tfr tf2]=tfrpart(x,tps,Nre,h,0.4,1);

ncenter=max(max(part));

% Carte propre
ncenter=max(max(part));
etiq=zeros(1,ncenter);
npart=0;
for ncol=1:ncenter,
  npoint=sum(sum(part==ncol));
  if (npoint>100),
    npart=npart+1;
    indic=find(part==ncol);
    part2(indic)=npart*ones(size(indic));
    etiq(npart)=ncol;
    clear indic
  end;
end;

Nc=npart;
center2=zeros(1,Nc); % centres dans la carte propre
center2=center(etiq(1:Nc));

part=part2;
center=center2;

dspe=NaN*zeros(1,Nc);
dinf=NaN*zeros(1,Nc);
denc=NaN*zeros(1,Nc);
dishsp=NaN*zeros(1,Nc);
y=zeros(length(tps),Nc);

for ncol=1:Nc,
  % Pour chaque composante :
  % Reconstruction de chaque composante
  masc=(part==ncol);
  y(:,ncol)=tffilter(masc,x(tps),1:length(tps),1);
  % [tfrrec tmes fmes]=tfrsp(y(:,ncol),1:length(tps),Nre,h,1);
  % df=fmes(2)-fmes(1); clear tmes fmes; dt=1; d=dt*df; 
  
  % Information
  % Masque surechantillonnne
  masc4=zeros(N,length(tps));
  fact=N/Nre;
  for jcol=1:Nre,
    nres=fact*(jcol-1)+1;
    masc4(nres:nres+3,:)=ones(fact,1)*masc(jcol,:);
  end;
  tfrrec=tfrsp(y(:,ncol),1:length(tps),N,h,1);
  
  % Calcul de la diff. des entropies de SH sur sp et sp reconst
  dinf(ncol)=renyi2(tfrrec,t2,f2,1)-renyi2(tfr2.*masc4,t2,f2,1);
  
  % Calcul de ISH+SP
  dishsp(ncol)=renyi2(tfr2.*masc4,t2,f2,1);
  
  % Calcul Surface equivalente
  [tv fv]=meshgrid(t2,f2(1:N/2));
  df=f2(2)-f2(1); dt=1; d=dt*df; 
  tfr3=tfr2.*masc4;tfr3=tfr3/(d*sum(sum(tfr3(1:N/2,:))));
  mt=d*sum(sum(tv.*tfr3(1:N/2,:))); mf=d*sum(sum(fv.*tfr3(1:N/2,:)));
  denc(ncol)=d*sum(sum((((tv-mt)/deltat).^2+((fv-mf)/deltaf).^2).*tfr3(1:N/2,:)));
 
  % Calcul de l'energie a l'exterieur du bassin d'attraction
  dspe(ncol)=d*sum(sum(tfrrec(1:N/2,:).*(1-masc4(1:N/2,:))))/norm(y(:,ncol))^2;
  % fprintf('\nverif. : %3.2f \n',d*sum(sum(tfrrec))/norm(y(:,ncol))^2);
end;

figure(1);
f=(0:Nre/2-1)/Nre;

subplot(2,2,1);
imagesc(1:length(tps),f,tfr(1:Nre/2,:));
axis('xy');
colormap(flipud(gray));
xlabel('temps');
ylabel('frequence');
title('(a)');

subplot(2,2,2);
masc=(part==2);
image(1:length(tps),f,8*part(1:Nre/2,:));
hold on;
plot(real(center),imag(center)/Nre,'+');
for pcol=1:Nc,
  text(real(center(pcol))-3,imag(center(pcol))/Nre+0.03,num2str(pcol));
end;
contour(1:length(tps),f,masc(1:Nre/2,:),[1],'k--');
hold off
axis('xy');
colormap(flipud(gray));
xlabel('temps');
ylabel('frequence');
title('(b)');

subplot(2,2,3);	
masc=(part==2);
imagesc(1:length(tps),f,tfr(1:Nre/2,:).*masc(1:Nre/2,:));
hold on
contour(1:length(tps),f,masc(1:Nre/2,:),[1],'k--');
hold off
axis('xy');
colormap(flipud(gray));
xlabel('temps');
ylabel('frequence');
title('(c) S_n');

subplot(2,2,4);
tfrrec=tfrsp(y(:,2),1:length(tps),Nre,h,1);
masc=(part==2);
imagesc(1:length(tps),f,tfrrec(1:Nre/2,:));
hold on
contour(1:length(tps),f,masc(1:Nre/2,:),[1],'k--');
hold off
axis('xy');
colormap(flipud(gray));
xlabel('temps');
ylabel('frequence');
title('(d) S_n^{(r)}');

% set(gcf,'PaperPosition',[0.18 3.74 8.14 3.52]);
% print -deps These/chap3/merging1.ps

disp('Tableau 3.1 :')
disp('Surface equivalente : ');
fprintf('%3.2f ',denc);
fprintf('\n borne : %3.2f\n',(1/(2*pi)));
disp('Information de Sh. : ');
fprintf('%3.2f ',2.^(dishsp-irefsp));
fprintf('\n borne : %3.2f\n',1);
disp('Energie ext. au domaine');
fprintf('%3.2f ',dspe);
fprintf('\n borne : %3.2f\n',0.5);
disp('Difference d''info. de Sh : ');
fprintf('%3.2f ',2.^(dinf-irefsp));
fprintf('\n borne : %3.2f\n',1);

