% Chapitre 3 : Forme analytique du champ de reallocation de N logons au
% hazard.

clear
% signal
te=1/5; fe=1/te;
t0=5;
t=(-3*t0/te:3*t0/te)';
tps=1:length(t);
N=5;
tn=2*t0*(rand(1,N)-1/2); wn=2*t0*(rand(1,N)-1/2);

s=zeros(size(t));
for ncol=1:N,
  s=s+exp(-(t*te-tn(ncol)).^2/2).*exp(i*wn(ncol)*t*te).*exp(2*pi*i*0.25*t);
end;

% s2=exp(-(t*te-t0).^2/2).*exp(2*pi*i*0.25*t);
% s3=exp(-(t*te).^2/2).*exp(i*t0*t*te).*exp(2*pi*i*0.25*t);
% s=s1+s2+s3;

% fenetre
th=-63:63;h=exp(-(th*te).^2/2);

% parametre
Nre=64;
tt=te*t; ff=2*pi*fe*(-Nre/2:Nre/2-1)/Nre;

% tfr=tfrsp(s,tps,Nre,h',1);
% keyboard;

% partition
[part center tfr tf2]=tfrpart(s,tps,Nre,h',0.4,1);

% tf map cleaning
part2=zeros(size(part));
ncount=1;
for ncol=1:max(max(part));
  npoint=sum(sum(part==ncol));
  if npoint>100,
    part2=part2+ncount*(part==ncol);
    ncount=ncount+1;
  end;
end;
part=part2;

% tesselation
[vt, vw] = voronoi([tn t0*[-10 -10 10 10]],[wn t0*[-10 10 -10 10]]);

figure(1);
clf;
% spectrogramme
subplot(1,2,1);
tfr=[tfr(3*Nre/4+1:Nre,:);tfr(1:3*Nre/4,:)];
imagesc(tt,ff,tfr);
axis('xy');
xlabel('temps');
ylabel('frequence');
title('(a)');
axis('square');
colormap(flipud(gray));

% partition
subplot(1,2,2);
part=[part(3*Nre/4+1:Nre,:);part(1:3*Nre/4,:)];
image(tt,ff,8*part);
hold on;
plot(tn,wn,'r+');
hold on;
plot(vt,vw,'b-');
hold off
axis('xy');
xlabel('temps');
ylabel('frequence');
axis('square');
title('(b)');
colormap(flipud(gray));

% print -deps These/chap3/logonn.ps
