% Chapitre 3, WV des fenetres pour la figure 1

clear
te=1/20; fe=1/te;

th1=-128:128; h1=exp(-(th1*te/2).^2/2).*exp(2*pi*i*0.25*th1);
h1=h1/norm(h1);
th2=-128:128; h2=exp(-(th2*te).^2/2).*exp(2*pi*i*0.25*th2);
h2=h2/norm(h2);
th3=-128:128; h3=exp(-(th3*te*2).^2/2).*exp(2*pi*i*0.25*th3);
h3=h3/norm(h3);

wv1=tfrwv(h1.',1:257,512,1); wv1=wv1/max(max(wv1));
wv2=tfrwv(h2.',1:257,512,1); wv2=wv2/max(max(wv2));
wv3=tfrwv(h3.',1:257,512,1); wv3=wv3/max(max(wv3));

M=6;
t=te*(-128:128); f=2*pi*fe*(-256:255)/1024;

figure(1);
subplot(2,3,1);
contour(t,f,wv1,1./[1 4 16],'k');
axis([-M M -M M]);
xlabel('temps');
ylabel('frequence');
title('(a)');
axis('square');

subplot(2,3,2);
contour(t,f,wv2,1./[1 4 16],'k');
axis([-M M -M M]);
xlabel('temps');
ylabel('frequence');
title('(b)');
axis('square');

subplot(2,3,3);
contour(t,f,wv3,1./[1 4 16],'k');
axis([-M M -M M]);
xlabel('temps');
ylabel('frequence');
title('(c)');
axis('square');

subplot(2,3,4);
plot(t,abs(h1));
axis([-M M 0 max(h1)]);
xlabel('temps');
h=get(gca,'position');
set(gca,'position',h.*[1 1 1 0.5]+[0 0.25 0 0]);

subplot(2,3,5);
plot(t,abs(h2));
axis([-M M 0 max(h2)]);
xlabel('temps');
h=get(gca,'position');
set(gca,'position',h.*[1 1 1 0.5]+[0 0.25 0 0]);

subplot(2,3,6);
plot(t,abs(h3));
axis([-M M 0 max(h3)]);
xlabel('temps');
h=get(gca,'position');
set(gca,'position',h.*[1 1 1 0.5]+[0 0.25 0 0]);

% print -deps These/chap3/fig3a2.ps




