% CHAPITRE 3
% Programme de comparaison de comptage de composante
% par les approches realloc diff., et informationnelle
% Genere le fichier cominfo.mat utilise ensuite par comfig.m

Nre=64;
N=256;

% Parametres reglables (ecart temp., phase) 
T=4:21;
% T=8:2:22;
T=T(5);
PHI=linspace(0,pi,21); % PHI=pi; PHI=PHI(20);

ncsp=zeros(length(PHI),length(T));
ncwv=zeros(length(PHI),length(T));
ncre=zeros(length(PHI),length(T));

t0=ceil(sqrt(Nre)*sqrt(-log(1e-3)/pi));
h=amgauss(2*t0+1,t0+1,sqrt(Nre));
h=h/norm(h);

% Signal

logon1=h;
logon2=h;
long1=2*t0+1;
long2=2*t0+1;
gamma1=1/Nre;

% Information de reference
tps=long1+1+(-31:32);
xref=zeros(2*long1+1,1);
mid1=long1+1;
xref(mid1+(-(long1-1)/2:(long1-1)/2))=xref(mid1+(-(long1-1)/2:(long1-1)/2))+logon1;
xref=xref.*exp(2*pi*i*0.25*(1:2*long1+1)');
xref=xref/norm(xref);

[tfrref t f]=tfrwv(xref,tps,N);
irefwv=renyi3(tfrref,t,f,3),

[tfrref tref fref]=tfrsp(xref,tps,N,h);
irefsp=renyi2(tfrref,tref,fref,1),

tps=2*long1+1+(-31:32);

% Mesure
for tcol=1:length(T),
 for pcol=1:length(PHI),

   % Signal
   Trow=T(tcol);
   x=zeros(4*long1+1,1);
   mid1=2*long1+1+ceil(Trow/2); mid2=2*long1+1-floor(Trow/2);
   x(mid1+(-(long1-1)/2:(long1-1)/2))=x(mid1+(-(long1-1)/2:(long1-1)/2))+logon1*exp(i*PHI(pcol));
   original=x(tps);
   x(mid2+(-(long2-1)/2:(long2-1)/2))=x(mid2+(-(long2-1)/2:(long2-1)/2))+logon2;
   x=x.*fmconst(4*long1+1,0.25,mid1);

   % Inofrmation SP +ISH
   [tfr t f]=tfrsp(x,tps,N,h);
   ncsp(pcol,tcol)=2^(renyi2(tfr,t,f,1)-irefsp);
   
   [tfr t f]=tfrwv(x,tps,N);
   ncwv(pcol,tcol)=2^(renyi3(tfr,t,f,3)-irefwv);
   
   % keyboard;
 if (tcol==3)&(pcol==18),
     ncre(pcol,tcol)=1;
 else
   % Reallocation
   [part center tfr tf2]=tfrpart(x,tps,Nre,h,0.4,1);
   ncenter=max(max(part));
   npart=0;
   for ncol=1:ncenter,
    npoint=sum(sum(part==ncol));
    npart=npart+(npoint>100);
   end;
   ncre(pcol,tcol)=npart;
 end;   
 
 end;
end;

% Resultat theorique sur WV
gamma = gamma1;
amin = T(1)/2;
amax = T(length(T))/2;
A = linspace(amin, amax,50); % ! A : demi ecart entre logon (i.e, =T/2)!
Phi=PHI;
[a phi]=meshgrid(A,Phi);
c = -a;

w = 1; r = 1; M = 0; m = 0;

xx = exp(-2*pi.*a.^2*gamma/3);
yy = cos(phi);
vv = cosh(log(r));
 
Q = 4/3-(1-xx.^2).^3.*(1+xx.^2).*(vv-xx.*yy)./(vv+xx.^3.*yy).^3;
H = -log2(Q)/2;
ncwvt=2.^(H+0.208);

% Graphique

%figure(1);
%mesh(T,PHI,ncsp);
%xlabel('T');
%ylabel('\phi');
%colormap(zeros(size(jet)));
%title('SP + ISH, simu');
%figure(2);
%mesh(T,PHI,ncwv);
%xlabel('T');
%ylabel('\phi');
%colormap(zeros(size(jet)));
%title('WV + IR3, simu');
%figure(3);
%mesh(2*A,Phi,ncwvt);
%colormap(zeros(size(jet)));
%xlabel('T');ylabel('\phi');
%title('WV+IR3, theo');

figure(1);
image(T,PHI,16*(ncre-1));
colormap(flipud(gray));
axis('xy');
hold on
[cs,h]=contour(2*A,Phi,ncwvt,[1.5 1.9 2.5],'k');
clabel(cs,h);
hold on
contour(T,PHI,ncwv,[1.5 1.9 2.5],'r');
[cs,h]=contour(T,PHI,ncsp,[1.5 1.9],'b--');
clabel(cs,h);
hold off
axis([T(1) T(end) 0 pi]);
xlabel('t_0');ylabel('\phi');

save /home/damiel/echassan/These/chap3/cominfo T PHI A Phi ncsp ncwv ncwvt ncre






















