
T=1024;
N=128;
gam=50,
w0=2*pi/16;
beta=w0*gam-1/2
alp=0;
theta=atan(2*alp*gam*(alp+beta+1)/(alp+beta)/(2*beta+1))*180/pi
alp+beta,beta,

if (alp+beta<.5)|(beta<.5),
  error('Conditions de convergence !');
end

x=anasing(T,T/2,-alp-1); 

clf;
plot(real(x));
drawnow

[tfr rtfr a]=tfrrscalo3(x,1:T,[1 5 N 0],'klauder',[gam w0/2/pi 1e-3],1);

c=(alp+beta+1)/(2*w0);

ha=1.3;
hb=0;

bmax=c*ha;

b=linspace(-bmax,bmax,100);
aps=(c*ha+sqrt(c^2*ha^2-b.^2))/gam;
ams=(c*ha-sqrt(c^2*ha^2-b.^2))/gam;
%bs=(1+beta/alp)*hb*ones(size(a));
%asol1=(c*ha+sqrt(c^2*ha^2-bs(1)^2))/gam;
%asol2=(c*ha-sqrt(c^2*ha^2-bs(1)^2))/gam;

figure(1)
tfr=tfr/max(max(tfr));
v=[0.4 0.2 0.1];

subplot(1,3,1);
contour(-(T/2-1):T/2,a(1:N/2),tfr(1:N/2,1:T),v,'k');
axis('square');
grid on

hold on;
plot(b,aps,'--');
plot(b,ams,'--');
%plot(bs,a,'--');
%plot(bs(1),asol1,'o');
%plot(bs(1),asol2,'o');

plot(hb,ha,'x');
axis([-35 35 0 3]);
%hold off

xlabel('temps');
ylabel('echelle');
title('(a)');
axis('square');

subplot(1,3,2);
b=-(T/2-1):T/2;
imagesc(b,a(1:N/2),rtfr(1:N/2,1:T));
hold on;
plot(b,2*w0*(alp+beta)/((alp+beta+1)*abs(alp))*abs(b),'k--');
plot(hb,ha,'x');
hold off
axis([-35 35 0 3]);
axis('xy');
colormap(flipud(gray))
xlabel('temps');
ylabel('echelle');
title('(b)');
axis('square');

subplot(1,3,3);
loglog(a(1:N/2),rtfr(1:N/2,T/2));
hold on;
loglog(a,rtfr(100,T/2)*(a/a(100)).^(2*alp),'--'); % 2H+1
% loglog(a,rtfr(100,T/2)*(a/a(100)).^(beta-alp+1),'--'); % 2H+1
%axis([1 3 0 3]);
xlabel('echelle');
ylabel('amplitude');
title('(c)');
axis('square');
axis([a(1) a(N/2) 1 10]);

% set(gcf,'PaperPosition',[0.235 3.74 8.03 3.52]);
% print -deps These/chap2/klau2.ps
