f0=64/256;
fm=(64+5)/256;
tm=128;
%[s,ifl]=fmlin(256,0,0.5);
s=exp(2*pi*i*(f0-1/256)*(1:256).');
h=window(31,'gauss',1e-3); %sinc(-20:0.2:20).';
h=h/norm(h);
[dum th]=loctime(h); th=th/sqrt(4*pi);
[dum fh]=locfreq(h); fh=fh/sqrt(4*pi);
clear dum;

t=tm;%50:256-50;
[dum s1]=opreassp(s,t,256,h,1);
s1=s1(fm*256);
r0=real(dum(fm*256))/th+i*imag(dum(fm*256))/fh/256;

ff=linspace(-3,3,301);
deltaf=ff(2)-ff(1);
tt=linspace(-3,3,301);
deltat=tt(2)-tt(1);
r=[ones(1,length(ff))]'*[tt]+i*[ff]'*[ones(1,length(tt))];
rr=1+abs(r).^2;

clf
subplot(1,2,1)
dtf=1./(pi*rr.^2);
plot(ff,sum(dtf')*deltat);hold on
dfmax=max(sum(dtf')*deltat);
dfmin=min(sum(dtf')*deltat);
ffmax=ff(find((sum(dtf')*deltat)==dfmax));
h=text(ffmax+0.2,dfmax+0.2,['noise only']);
set(h,'FontName','times'); set(h,'FontSize',10);

subplot(1,2,2)
plot(ff,log10(sum(dtf')*deltat));hold on
ldfmax=log10(dfmax);
ldfmin=log10(dfmax);
h=text(ffmax+0.2,ldfmax+0.2,['noise only']);
set(h,'FontName','times');
set(h,'FontSize',10);

for snr=[0 10 20],
 dtf=(1+10^(snr/10)*(abs(1+r*conj(r0)).^2)./rr).*exp(-10^(snr/10)*(abs(r-r0).^2)./rr)./(pi*rr.^2);
 subplot(1,2,1)
 plot(ff,sum(dtf')*deltat);
 dfmax=max(sum(dtf')*deltat);
 dfmin=min(sum(dtf')*deltat);
 ffmax=ff(find((sum(dtf')*deltat)==dfmax));
 h=text(ffmax+0.2,dfmax+0.2,['SNR= ' int2str(snr) ' dB']);
 set(h,'FontName','times');
 set(h,'FontSize',10);
 subplot(1,2,2)
 plot(ff,log10(sum(dtf')*deltat));
 ldfmax=log10(dfmax);
 ldfmin=log10(dfmax);
 h=text(ffmax+0.2,ldfmax+0.2,['SNR= ' int2str(snr) ' dB']);
 set(h,'FontName','times');
 set(h,'FontSize',10);
end;

subplot(1,2,1)
plot(imag([r0 r0]),[0 dfmax+0.5],'--');
axis([-2 2 0 dfmax+0.5]);
axis('square');
xlabel('frequence');
ylabel('marginale en frequence');

subplot(1,2,2)
plot(imag([r0 r0]),[-2 1],'--');
axis([-2 2 -2 1]);
axis('square');
xlabel('frequence');
ylabel('log-marginale en frequence');

% print -deps These/chap2/figure9.ps
