
h=sinc(-20:0.2:20).';
h=h/norm(h);
[dum th]=loctime(h); th=th/sqrt(4*pi);
[dum fh]=locfreq(h); fh=fh/sqrt(4*pi);
clear dum;;

nreal=5;	
t=100:512-100; f=100:256-100;
opreas=zeros(length(t)*length(f),nreal);
for n=1:nreal,
 b=noisecg(512);
 tf=opreassp(b,t,512,h,1);
 tf=tf(f,:);
 tf=tf(:);
 opreas(:,n)=real(tf)/th+i*imag(tf)/fh/512;
end;
opreas=opreas(:);

% histogramme
nhist=200;
opreas=opreas((real(opreas)>-3)&(real(opreas)<3)&(imag(opreas)>-3)&(imag(opreas)<3));
tt=linspace(min(real(opreas)),max(real(opreas)),nhist);
ff=linspace(min(imag(opreas)),max(imag(opreas)),nhist);
htf=zeros(length(ff),length(tt));

disp('Histogram');
for n=2:nhist;
 disprog(n,nhist,10),
 tf=opreas(find((imag(opreas)>=ff(n-1))&(imag(opreas)<ff(n))));
 if ~(isempty(tf))
  bt=hist(real(tf),tt);
  htf(n,:)=bt;
 end
end;
deltat=tt(2)-tt(1);
deltaf=ff(2)-ff(1);
htf=htf/(sum(sum(htf))*deltat*deltaf);
%htf=htf(find((ff>-3)&(ff<3)),find((tt>-3)&(tt<3)));
%tt=tt((tt>-3)&(tt<3));ff=ff((ff>-3)&(ff<3));

% theorique
r=[ones(1,length(tt))]'*[tt]+i*[ff]'*[ones(1,length(ff))];
rr=1+abs(r).^2;
dtf=1./(pi*rr.^2);

figure(1);

subplot(1,2,2);
mesh(tt(1:2:200),ff(1:2:200),log10(dtf(1:2:200,1:2:200)));
title('theorie');
axis([-3 3 -3 3 -3 0]);
view(60,15);

subplot(1,2,2);
mesh(tt(1:2:200),ff(1:2:200),log10(htf(1:2:200,1:2:200)));
title('estimation');
axis([-3 3 -3 3 -3 0]);
view(60,15);

colormap(zeros(size(jet)));

% print -deps These/chap2/figure10.ps

figure(2);

subplot(1,2,1);
plot(ff,log10(sum(dtf)*deltaf));hold on;plot(tt,log10(sum(htf')*deltaf),'+');hold off;
grid;axis([-3 3 -2 0]);axis('square');
title('marginale en temps');xlabel('temps');ylabel('log10(pdf)');

subplot(1,2,2);
plot(ff,log10(sum(dtf')*deltat));hold on;plot(ff,log10(sum(htf')*deltat),'+');hold off;
grid;axis([-3 3 -2 0]);axis('square');
title('marginale en frequence');xlabel('frequence');ylabel('log10(pdf)');
% print -dps These/chap2/figure11.ps

figure(3);
plot(-100:100,h); axis('square'); axis([-100 100 -0.1 0.5]);
% print -dps These/chap2/figure12.ps
