xx = [0 1 .8 1 .8].';
yy = [0 0 .08 0 -.08].';
arrow = xx + yy.*sqrt(-1);

subplot(1,3,1);
tw=1.5+1*i;
htw=1+1*i;
plot([real(htw) real(htw)],[0 2],'--k');
set(gca,'xtick',real(htw));
set(gca,'xticklabel','s');
set(gca,'ytick',[]);
hold on;
plot(arrow*(htw-tw)+ones(5,1)*tw,'k');
plot(real(tw),imag(tw),'+');
text(real(tw),imag(tw)+0.1,'(t,w)');
plot(real(htw),imag(htw),'+');
text(real(htw)-0.7,imag(htw)+0.1,'(\^t,\^w)');
axis([0 2 0 2]);
hold off
axis('square');
xlabel('temps');
ylabel('frequence');
title('(a)');


subplot(1,3,2);
tw=1+1.5*i;
htw=1+1*i;
plot([0 2],[imag(htw) imag(htw)],'--k');
set(gca,'ytick',[1]);
set(gca,'yticklabel',[' ']);
h=text(-0.1,imag(htw),'x');
set(h,'fontname','symbol');
set(gca,'xtick',[]);
hold on;
plot(arrow*(htw-tw)+ones(5,1)*tw,'k');
plot(real(tw),imag(tw),'+');
text(real(tw),imag(tw)+0.1,'(t,w)');
plot(real(htw),imag(htw),'+');
text(real(htw),imag(htw)-0.1,'(\^t,\^w)');
axis([0 2 0 2]);
hold off
axis('square');
xlabel('temps');
ylabel('frequence');
title('(b)');

subplot(1,3,3);
xi=sqrt(2);
tw=1+1.5*i;
htw=(sqrt(2)*xi-(imag(tw)-real(tw)))/2+i*(sqrt(2)*xi+(imag(tw)-real(tw)))/2;
plot([0 2],[0 2],'-k');
set(gca,'xtick',[]);
set(gca,'ytick',[]);
hold on;
plot([0 2],[2 0],'--k');
h=text(1+0.2,1,'x');
set(h,'fontname','symbol');
plot(arrow*(htw-tw)+ones(5,1)*tw,'k');
plot(real(tw),imag(tw),'+');
text(real(tw),imag(tw)+0.1,'(t,w)');
plot(real(htw),imag(htw),'+');
text(real(htw)-0.5,imag(htw),'(\^t,\^w)');
axis('square');
axis([0 2 0 2]);
hold off
xlabel('temps');
ylabel('frequence');
title('(c)');

% set(gcf,'paperposition',[0.18 3.905 8.14 3.19]);
% print -deps These/chap1/fiad.ps









