
% Chapitre 1 : principe de la realloc

[s1 if1]=fmlin(256,0.1,0.3);
s1=s1.*amgauss(256,128,100);
[s2 if2]=fmlin(256,0.2,0.4);
s2=s2.*amgauss(256,128,100);
s=s1+s2;
h=amgauss(65,33,sqrt(512));
% h=window(256,'gauss',10^(-16*pi));
h=h/norm(h);
Lh=(length(h)-1)/2;
% h=h(128-32:128+32);
wv=tfrwv(s,1:256,256,1);
[sp rsp tf2]=tfrrsp(s,1:256,512,h,1);
sp=sp(1:256,:);rsp=rsp(1:256,:);

t1=128;f1=129;
h1=zeros(256,1);
h1(t1-Lh:t1+Lh)=h;
h1=h1.*exp(2*pi*i*f1/512*(1:256)');
wvh1=tfrwv(h1,1:256,256,1);
wvh1=wvh1>1e-3;
wvs1=wv.*wvh1;
wvs1=wvs1+wv.*(0.4*(1-wvh1));

t2=120;f2=165;
h2=zeros(256,1);
h2(t2-Lh:t2+Lh)=h;
h2=h2.*exp(2*pi*i*f2/512*(1:256)');
wvh2=tfrwv(h2,1:256,256,1);
wvh2=wvh2>1e-3;
wvs2=wv.*wvh2;
wvs2=wvs2+wv.*(0.4*(1-wvh2));


figure(1)
subplot(3,2,5);
th=100/2;
plot(128-th:128+th,if1(128-th:128+th));
hold on;plot(128-th:128+th,if2(128-th:128+th));hold off;
axis([0 256 0 0.5]);
set(gca,'xtick',[0]);
set(gca,'ytick',[0 0.5]);
xlabel('temps');ylabel('frequence');
title('(e) representation ideale');

subplot(3,2,1);
wv=wv.*(wv>=0);
imagesc(1:256,(1:256)/512,wv);
axis([0 256 0 0.5]);axis('xy');
set(gca,'xtick',[0]);
set(gca,'ytick',[0 0.5]);
% xlabel('temps');
ylabel('frequence');
title('(a) Wigner-Ville');

subplot(3,2,2);
imagesc(1:256,(1:256)/512,sp);
hold on
plot(t1,f1/512,'x');
plot(t2,f2/512,'+');
hold off
axis([0 256 0 0.5]);axis('xy');
colormap(flipud(gray));
set(gca,'xtick',[0]);
set(gca,'ytick',[0 0.5]);
% xlabel('temps');
ylabel('frequence');
title('(b) spectrogramme');

subplot(3,2,6);
imagesc(1:256,(1:256)/512,rsp);
axis([0 256 0 0.5]);axis('xy');
set(gca,'xtick',[0]);
set(gca,'ytick',[0 0.5]);
xlabel('temps');
ylabel('frequence');
title('(f) sp. realloue');

subplot(3,2,3);
wvs1=wvs1.*(wvs1>0);
imagesc(1:256,(1:256)/512,wvs1);
hold on
contour(1:256,(1:256)/512,wvh1,1,'k');
plot(t1,f1/512,'.');
% plot(imag(tf2(f1,t1)),real(tf2(f1,t1))/512,'x');
hold off;
axis([0 256 0 0.5]);axis('xy');
set(gca,'xtick',[0]);
set(gca,'ytick',[0 0.5]);
% xlabel('temps');
ylabel('frequence');
title('(c) point (x) - interferences');

subplot(3,2,4);
wvs2=wvs2.*(wvs2>0);
imagesc(1:256,(1:256)/512,wvs2);
hold on
contour(1:256,(1:256)/512,wvh2,1,'k');
plot(t2,f2/512,'.');
plot(imag(tf2(f2,t2)),real(tf2(f2,t2))/512,'o');
hold off;
axis([0 256 0 0.5]);axis('xy');
set(gca,'xtick',[0]);
set(gca,'ytick',[0 0.5]);
% xlabel('temps');
ylabel('frequence');
title('(d) point (+) - voisinage composante');

colormap(flipud(gray));

% print -deps These/chap1/fiaa.ps
